/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.definition;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.webharvest.definition.XmlNode;
import org.webharvest.exception.ParserException;
import org.webharvest.utils.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class XmlParser
extends DefaultHandler {
    protected static Logger log = Logger.getLogger(XmlParser.class);
    XmlNode root;
    private transient Stack elementStack = new Stack();
    private Locator locator;

    public static XmlNode parse(InputSource in) {
        long startTime = System.currentTimeMillis();
        XmlParser handler = new XmlParser();
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(false);
            parserFactory.setNamespaceAware(false);
            SAXParser parser = parserFactory.newSAXParser();
            parser.parse(in, (DefaultHandler)handler);
            log.info((Object)("XML parsed in " + (System.currentTimeMillis() - startTime) + "ms."));
        }
        catch (Exception e) {
            throw new ParserException(e.getMessage(), e);
        }
        return handler.root;
    }

    public XmlParser() {
        this.setDocumentLocator(new LocatorImpl());
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private XmlNode getCurrentNode() {
        return this.elementStack.size() > 0 ? (XmlNode)this.elementStack.peek() : null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        XmlNode currNode = this.getCurrentNode();
        if (currNode != null) {
            currNode.addElement(new String(ch, start, length));
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        XmlNode currNode = this.getCurrentNode();
        XmlNode newNode = new XmlNode(qName, currNode);
        newNode.setLocation(this.locator.getLineNumber(), this.locator.getColumnNumber());
        this.elementStack.push(newNode);
        if (currNode == null) {
            this.root = newNode;
        }
        int attsCount = attributes.getLength();
        for (int i = 0; i < attsCount; ++i) {
            newNode.addAttribute(attributes.getQName(i), attributes.getValue(i));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.elementStack.size() > 0) {
            this.getCurrentNode().flushText();
            this.elementStack.pop();
        }
    }
}

