/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.definition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.webharvest.definition.ConstantDef;
import org.webharvest.definition.DefinitionResolver;
import org.webharvest.definition.IElementDef;
import org.webharvest.definition.XmlNode;

public class BaseElementDef
implements IElementDef {
    List operationDefs = new ArrayList();
    String body;
    String id;
    private String descName = "*";
    private int lineNumber;
    private int columnNumber;

    protected BaseElementDef() {
    }

    protected BaseElementDef(XmlNode node) {
        this(node, true);
    }

    protected BaseElementDef(XmlNode node, String descName) {
        this(node);
        this.descName = descName;
    }

    protected BaseElementDef(XmlNode node, boolean createBodyDefs) {
        if (node != null) {
            this.lineNumber = node.getLineNumber();
            this.columnNumber = node.getColumnNumber();
            this.id = (String)node.get("id");
            List elementList = node.getElementList();
            if (createBodyDefs) {
                if (elementList != null && elementList.size() > 0) {
                    for (Object element : elementList) {
                        if (element instanceof XmlNode) {
                            XmlNode currElementNode = (XmlNode)element;
                            IElementDef def = DefinitionResolver.createElementDefinition(currElementNode);
                            if (def == null) continue;
                            this.operationDefs.add(def);
                            continue;
                        }
                        this.operationDefs.add(new ConstantDef(element.toString()));
                    }
                } else {
                    this.body = node.getText();
                }
            }
        }
    }

    public boolean hasOperations() {
        return this.operationDefs != null && this.operationDefs.size() > 0;
    }

    public IElementDef[] getOperationDefs() {
        IElementDef[] defs = new IElementDef[this.operationDefs.size()];
        Iterator it = this.operationDefs.iterator();
        int index = 0;
        while (it.hasNext()) {
            defs[index++] = (IElementDef)it.next();
        }
        return defs;
    }

    public String getBodyText() {
        return this.body;
    }

    public String getId() {
        return this.id;
    }

    public String getShortElementName() {
        return this.descName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }
}

