/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui.component;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.webharvest.gui.component.WHComboBox;
import org.webharvest.utils.CommonUtil;

public abstract class EditableComboBox
extends WHComboBox {
    private boolean addNewItemsOnTop = false;
    private boolean isUppercase = false;
    private int fixedItemsSize = -1;
    private int dropDownLimit = -1;
    private int length;
    private ActionListener[] actionListeners;
    private boolean isSelectedFromPopup = false;

    public EditableComboBox(int length, boolean addNewItemsOnTop) {
        this(length);
        this.addNewItemsOnTop = addNewItemsOnTop;
    }

    public EditableComboBox(int length) {
        this.length = length;
        this.setEditable(true);
        JTextField editField = (JTextField)this.getEditor().getEditorComponent();
        editField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (!(e.getKeyChar() != '\n' || e.isControlDown() || e.isAltDown() || e.isShiftDown())) {
                    Object value = EditableComboBox.this.getEditor().getItem();
                    if (EditableComboBox.this.isValidValue(value)) {
                        EditableComboBox.this.select(value);
                        EditableComboBox.this.onValue();
                    }
                } else {
                    if (EditableComboBox.this.isUppercase) {
                        e.setKeyChar(Character.toUpperCase(e.getKeyChar()));
                    }
                    super.keyTyped(e);
                }
            }
        });
        this.addPopupMenuListener(new PopupMenuListener(){
            private int selectedIndex = -1;

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                EditableComboBox.this.isSelectedFromPopup = true;
                this.selectedIndex = EditableComboBox.this.getSelectedIndex();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (EditableComboBox.this.isSelectedFromPopup && this.selectedIndex != EditableComboBox.this.getSelectedIndex()) {
                    EditableComboBox.this.onValue();
                }
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                EditableComboBox.this.isSelectedFromPopup = false;
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if ("comboBoxChanged".equals(e.getActionCommand())) {
                    if (!EditableComboBox.this.isPopupVisible()) {
                        Object value = EditableComboBox.this.getEditor().getItem();
                        if (EditableComboBox.this.isValueInList(value)) {
                            EditableComboBox.this.onValue();
                        }
                    } else {
                        EditableComboBox.this.isSelectedFromPopup = true;
                    }
                }
            }
        });
        editField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ((JTextField)EditableComboBox.this.getEditor().getEditorComponent()).selectAll();
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    private boolean isValueInList(Object value) {
        if (value != null) {
            int itemCount = this.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                if (!value.equals(this.getItemAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public final void onValue() {
        Object value = this.getEditor().getItem();
        if (this.isValidValue(value)) {
            this.select(value);
            this.execute(value);
        }
    }

    protected boolean isValidValue(Object value) {
        return value != null;
    }

    protected abstract void execute(Object var1);

    public void setDropDownLimit(int dropDownLimit) {
        this.dropDownLimit = dropDownLimit;
    }

    public void setFixedItemsSize(int fixedItemsSize) {
        this.fixedItemsSize = fixedItemsSize;
    }

    public Object getValue() {
        return this.getEditor().getItem();
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int charsWidth = this.getFontMetrics(this.getFont()).charWidth('H') * this.length;
        return new Dimension(charsWidth, size.height);
    }

    public void removeFromCombo(Object item) {
        if (item != null) {
            String itemAsString = item.toString();
            int itemCount = this.getItemCount();
            for (int i = Math.max(0, this.fixedItemsSize); i < itemCount; ++i) {
                Object currItem = this.getItemAt(i);
                if (!itemAsString.equals(currItem.toString())) continue;
                ActionListener[] actionListeners = this.getActionListeners();
                this.disableActionListeners();
                this.removeItem(currItem);
                this.enableActionListeners();
                return;
            }
        }
    }

    private boolean itemExists(Object item) {
        if (item != null) {
            String itemAsString = item.toString();
            int itemCount = this.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                Object currItem = this.getItemAt(i);
                if (currItem == null || !itemAsString.equals(currItem.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public void addItem(Object item) {
        if (CommonUtil.isEmptyString(item)) {
            return;
        }
        this.removeFromCombo(item);
        if (this.itemExists(item)) {
            return;
        }
        this.disableActionListeners();
        if (this.addNewItemsOnTop) {
            super.insertItemAt(item, 0);
        } else {
            super.addItem(item);
        }
        int count = this.getItemCount();
        if (this.dropDownLimit > 0 && count > this.dropDownLimit && count > this.fixedItemsSize) {
            if (this.addNewItemsOnTop) {
                this.removeItemAt(this.dropDownLimit - this.fixedItemsSize);
            } else {
                this.removeItemAt(this.fixedItemsSize);
            }
        }
        this.enableActionListeners();
    }

    public void select(Object item) {
        if (item != null) {
            this.addItem(item);
            String itemAsString = item.toString();
            int itemCount = this.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                Object currItem = this.getItemAt(i);
                if (currItem == null || !itemAsString.equals(currItem.toString())) continue;
                this.disableActionListeners();
                this.setSelectedIndex(i);
                this.enableActionListeners();
                break;
            }
        }
    }

    private void disableActionListeners() {
        if (this.actionListeners == null) {
            this.actionListeners = this.getActionListeners();
        }
        for (int j = 0; j < this.actionListeners.length; ++j) {
            this.removeActionListener(this.actionListeners[j]);
        }
    }

    private void enableActionListeners() {
        if (this.actionListeners != null) {
            for (int j = 0; j < this.actionListeners.length; ++j) {
                this.addActionListener(this.actionListeners[j]);
            }
            this.actionListeners = null;
        }
    }

    public boolean isUppercase() {
        return this.isUppercase;
    }

    public void setUppercase(boolean uppercase) {
        this.isUppercase = uppercase;
    }
}

