/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.tools;

import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFactory;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.DataServiceUser;
import org.wso2.carbon.dataservices.core.description.resource.Resource;
import org.wso2.carbon.dataservices.core.dispatch.BatchDataServiceRequest;
import org.wso2.carbon.dataservices.core.dispatch.SingleDataServiceRequest;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.DataServiceSerializer;
import org.wso2.carbon.dataservices.core.engine.ParamValue;

public class DSTools {
    public static DataService createDataService(OMElement dbsElement, String dsLocation) throws DataServiceFault {
        return DataServiceFactory.createDataService(dbsElement, dsLocation);
    }

    public static OMElement serializeDataService(DataService dataService) {
        return DataServiceSerializer.serializeDataService(dataService);
    }

    public static void setDataServicesUser(DataServiceUser user) {
        DataService.setCurrentUser(user);
    }

    public static OMElement invokeOperation(DataService dataService, String operationName, Map<String, ParamValue> params) throws DataServiceFault {
        OMElement result = new SingleDataServiceRequest(dataService, operationName, params).dispatch();
        OMDocument doc = DBUtils.getOMFactory().createOMDocument();
        doc.addChild((OMNode)result);
        return doc.getOMDocumentElement();
    }

    public static void invokeOperation(DataService dataService, String operationName, List<Map<String, ParamValue>> batchParams) throws DataServiceFault {
        new BatchDataServiceRequest(dataService, operationName + "_batch_req", batchParams).dispatch();
    }

    public static OMElement accessResource(DataService dataService, String resourcePath, Map<String, ParamValue> params, String accessMethod) throws DataServiceFault {
        OMElement result = new SingleDataServiceRequest(dataService, Resource.generateRequestName(resourcePath, accessMethod), params).dispatch();
        OMDocument doc = DBUtils.getOMFactory().createOMDocument();
        doc.addChild((OMNode)result);
        return doc.getOMDocumentElement();
    }
}

