/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.types.NCName;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ExternalParam;
import org.wso2.carbon.dataservices.core.engine.ExternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.OutputElement;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;

public class CallQuery
extends OutputElement {
    private DataService dataService;
    private String queryId;
    private Query query;
    private Map<String, WithParam> withParams;
    private Set<String> requiredRoles;

    public CallQuery(DataService dataService, String queryId, Map<String, WithParam> withParams, Set<String> requiredRoles) {
        super(null);
        this.dataService = dataService;
        this.queryId = queryId;
        this.withParams = withParams;
        this.requiredRoles = requiredRoles;
    }

    public void init() throws DataServiceFault {
        this.query = this.getDataService().getQuery(this.getQueryId());
        this.setNamespace(this.getQuery().getNamespace());
        if (this.query == null) {
            throw new DataServiceFault("Query with the query id: '" + this.getQueryId() + "' cannot be found");
        }
    }

    @Override
    public Set<String> getRequiredRoles() {
        return this.requiredRoles;
    }

    @Override
    public boolean isOptional() {
        return this.getRequiredRoles() != null && this.getRequiredRoles().size() > 0;
    }

    public Map<String, WithParam> getWithParams() {
        return this.withParams;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public Query getQuery() {
        return this.query;
    }

    private Object evaluateGetProperty(String propName) throws DataServiceFault {
        if ("USERNAME".equals(propName)) {
            Object val;
            MessageContext context = MessageContext.getCurrentMessageContext();
            if (context != null && (val = context.getProperty("username")) != null) {
                return val.toString();
            }
        } else {
            if ("TENANT_ID".equals(propName)) {
                return String.valueOf(SuperTenantCarbonContext.getCurrentContext().getTenantId());
            }
            if ("USER_ROLES".equals(propName)) {
                MessageContext context = MessageContext.getCurrentMessageContext();
                if (context != null) {
                    return DBUtils.getUserRoles(context);
                }
            } else if ("NULL".equals(propName)) {
                return null;
            }
        }
        return null;
    }

    private ParamValue evaluateDefaultValue(ParamValue paramValue, String paramType) throws DataServiceFault {
        ParamValue result;
        Object evaluatedValue;
        if (paramValue.getValueType() != 1) {
            return paramValue;
        }
        String value = paramValue.getScalarValue();
        if (value != null && value.startsWith("#{") && value.endsWith("}")) {
            String propName = value.substring(2, value.length() - 1).trim();
            evaluatedValue = this.evaluateGetProperty(propName);
        } else {
            evaluatedValue = value;
        }
        if ("ARRAY".equals(paramType)) {
            result = new ParamValue(2);
            if (evaluatedValue instanceof ParamValue[]) {
                result.setArrayValue(Arrays.asList((ParamValue[])evaluatedValue));
            } else {
                result.addArrayValue(evaluatedValue == null ? null : new ParamValue(evaluatedValue.toString()));
            }
        } else {
            result = new ParamValue(1);
            if (evaluatedValue instanceof String[]) {
                String[] tmpArray = (String[])evaluatedValue;
                String tmpVal = null;
                if (tmpArray.length > 0) {
                    tmpVal = tmpArray[0];
                }
                result.setScalarValue(tmpVal);
            } else {
                result.setScalarValue(evaluatedValue == null ? null : evaluatedValue.toString());
            }
        }
        return result;
    }

    private void processDefaultValues(ExternalParamCollection params) throws DataServiceFault {
        List<QueryParam> queryParams = this.getQuery().getQueryParams();
        for (QueryParam queryParam : queryParams) {
            if (queryParam.getDefaultValue() == null) continue;
            params.addTempParam(queryParam.getName(), this.evaluateDefaultValue(queryParam.getDefaultValue(), queryParam.getParamType()));
        }
    }

    @Override
    protected void executeElement(XMLStreamWriter xmlWriter, ExternalParamCollection params, int queryLevel) throws DataServiceFault {
        this.processDefaultValues(params);
        Map<String, ParamValue> qparams = this.extractParams(params);
        this.getQuery().execute(xmlWriter, qparams, queryLevel);
        params.clearTempValues();
    }

    private Map<String, ParamValue> extractParams(ExternalParamCollection params) throws DataServiceFault {
        HashMap<String, ParamValue> qparams = new HashMap<String, ParamValue>();
        for (WithParam withParam : this.getWithParams().values()) {
            String paramName = withParam.getParam();
            String paramType = withParam.getParamType();
            ExternalParam paramObj = params.getParam(paramType, paramName);
            if (paramObj == null) {
                paramObj = params.getParam(paramName);
            }
            if (paramObj != null) {
                qparams.put(withParam.getName(), paramObj.getValue());
                continue;
            }
            if (params.getTempEntries().containsKey(withParam.getName())) continue;
            throw new DataServiceFault(DBConstants.FaultCodes.INCOMPATIBLE_PARAMETERS_ERROR, "Error in 'CallQuery.extractParams', cannot find parameter with type:" + paramType + " name:" + withParam.getOriginalName());
        }
        for (Map.Entry<String, ParamValue> entry : params.getTempEntries().entrySet()) {
            String key = entry.getKey();
            if (qparams.containsKey(key)) continue;
            qparams.put(key, entry.getValue());
        }
        return qparams;
    }

    public static class WithParam {
        private String name;
        private String originalName;
        private String param;
        private String paramType;

        public WithParam(String name, String originalName, String param, String paramType) throws DataServiceFault {
            this.name = name;
            this.originalName = originalName;
            this.param = param;
            this.paramType = paramType;
            this.validateWithParam();
        }

        private void validateWithParam() throws DataServiceFault {
            if ("query-param".equals(this.getParamType()) && !NCName.isValid((String)this.getParam())) {
                throw new DataServiceFault("Invalid query param name: '" + this.getParam() + "', must be an NCName.");
            }
        }

        public String getName() {
            return this.name;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public String getParam() {
            return this.param;
        }

        public String getParamType() {
            return this.paramType;
        }
    }
}

