/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.boxcarring.TLParamStore;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.engine.DataEntry;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ExternalParam;
import org.wso2.carbon.dataservices.core.engine.ExternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.InternalParam;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;
import org.wso2.carbon.dataservices.core.engine.XMLWriterHelper;
import org.wso2.carbon.dataservices.core.validation.ValidationContext;
import org.wso2.carbon.dataservices.core.validation.ValidationException;
import org.wso2.carbon.dataservices.core.validation.Validator;

public abstract class Query
extends XMLWriterHelper {
    private String queryId;
    private List<QueryParam> queryParams;
    private DataService dataService;
    private Result result;
    private boolean writeRow;
    private String configId;
    private EventTrigger inputEventTrigger;
    private EventTrigger outputEventTrigger;
    private Map<String, String> advancedProperties;
    private String inputNamespace;
    private boolean preBuildResult;
    private boolean useColumnNumbers;

    public Query(DataService dataService, String queryId, List<QueryParam> queryParams, Result result, String configId, EventTrigger inputEventTrigger, EventTrigger outputEventTrigger, Map<String, String> advancedProperties, String inputNamespace) {
        super(result != null ? result.getNamespace() : dataService.getDefaultNamespace());
        this.dataService = dataService;
        this.queryId = queryId;
        this.queryParams = queryParams;
        this.result = result;
        this.writeRow = this.getResult() != null && this.getResult().getRowName() != null && this.getResult().getRowName().trim().length() > 0;
        this.configId = configId;
        this.inputEventTrigger = inputEventTrigger;
        this.outputEventTrigger = outputEventTrigger;
        this.advancedProperties = advancedProperties;
        this.inputNamespace = inputNamespace;
        this.preBuildResult = this.checkPreBuildResult();
        if (result != null) {
            this.useColumnNumbers = result.isUseColumnNumbers();
        }
    }

    private boolean checkPreBuildResult() {
        return this.getOutputEventTrigger() != null || this.getResult() != null && this.getResult().getXsltTransformer() != null;
    }

    public String getInputNamespace() {
        return this.inputNamespace;
    }

    public boolean isPreBuildResult() {
        return this.preBuildResult;
    }

    public EventTrigger getInputEventTrigger() {
        return this.inputEventTrigger;
    }

    public EventTrigger getOutputEventTrigger() {
        return this.outputEventTrigger;
    }

    public Map<String, String> getAdvancedProperties() {
        return this.advancedProperties;
    }

    public String getConfigId() {
        return this.configId;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public List<QueryParam> getQueryParams() {
        return this.queryParams;
    }

    public Result getResult() {
        return this.result;
    }

    public boolean hasResult() {
        return this.getResult() != null;
    }

    public boolean isWriteRow() {
        return this.writeRow;
    }

    public boolean isUsingColumnNumbers() {
        return this.useColumnNumbers;
    }

    private InternalParamCollection extractParams(Map<String, ParamValue> params) throws DataServiceFault {
        InternalParamCollection ipc = new InternalParamCollection();
        Map<String, ParamValue> exportedParams = TLParamStore.getParameterMap();
        for (QueryParam queryParam : this.getQueryParams()) {
            ParamValue tmpParamValue = params.get(queryParam.getName());
            if (!(tmpParamValue != null || "OUT".equals(queryParam.getType()) || "INOUT".equals(queryParam.getType()) || (tmpParamValue = exportedParams.get(queryParam.getName())) != null || queryParam.hasDefaultValue())) {
                throw new DataServiceFault(DBConstants.FaultCodes.INCOMPATIBLE_PARAMETERS_ERROR, "Error in 'Query.extractParams', cannot find query param with name:" + queryParam.getName());
            }
            ipc.addParam(new InternalParam(queryParam.getName(), tmpParamValue, queryParam.getSqlType(), queryParam.getType(), queryParam.getStructType(), queryParam.getOrdinal()));
        }
        return ipc;
    }

    private void preprocessParams(Map<String, ParamValue> params) {
        ParamValue value = null;
        for (QueryParam queryParam : this.getQueryParams()) {
            if (queryParam.getType().equals("OUT") || !queryParam.getParamType().equals("ARRAY") || (value = params.get(queryParam.getName())) == null || value.getValueType() != 1) continue;
            params.put(queryParam.getName(), ParamValue.convertFromScalarToArray(value));
        }
    }

    private ValidationContext createValidationContext(Map<String, ParamValue> params) {
        ValidationContext context = new ValidationContext(params);
        return context;
    }

    private void validateParams(Map<String, ParamValue> params) throws DataServiceFault {
        try {
            ParamValue value = null;
            ValidationContext context = this.createValidationContext(params);
            for (QueryParam queryParam : this.getQueryParams()) {
                value = params.get(queryParam.getName());
                if (value == null) continue;
                for (Validator validator : queryParam.getValidators()) {
                    validator.validate(context, queryParam.getName(), value);
                }
            }
        }
        catch (ValidationException e) {
            throw new DataServiceFault(e, DBConstants.FaultCodes.VALIDATION_ERROR, null);
        }
    }

    public void execute(XMLStreamWriter xmlWriter, Map<String, ParamValue> params, int queryLevel) throws DataServiceFault {
        if (this.hasResult()) {
            if (DataService.getCurrentUser() != null) {
                this.getResult().applyUserRoles(DataService.getCurrentUser().getUserRoles());
            } else {
                this.getResult().applyUserRoles(null);
            }
        }
        this.preprocessParams(params);
        this.validateParams(params);
        InternalParamCollection internalParams = this.extractParams(params);
        this.processInputEvents(internalParams);
        this.runQuery(xmlWriter, internalParams, queryLevel);
    }

    private OMElement createOMElementFromInputParams(InternalParamCollection params) {
        OMFactory fac = DBUtils.getOMFactory();
        OMDocument doc = fac.createOMDocument();
        OMElement retEl = fac.createOMElement(new QName(this.getQueryId()));
        for (InternalParam param : params.getParams()) {
            ParamValue paramValue = param.getValue();
            if (paramValue.getValueType() == 1 || paramValue.getValueType() == 3) {
                OMElement scalarEl = fac.createOMElement(new QName(param.getName()));
                scalarEl.setText(paramValue.getScalarValue());
                retEl.addChild((OMNode)scalarEl);
                continue;
            }
            if (paramValue.getValueType() != 2) continue;
            List<OMElement> arrayEl = this.createOMElementsFromArrayValue(param.getName(), paramValue, fac);
            for (OMElement el : arrayEl) {
                retEl.addChild((OMNode)el);
            }
        }
        doc.addChild((OMNode)retEl);
        return doc.getOMDocumentElement();
    }

    private List<OMElement> createOMElementsFromArrayValue(String name, ParamValue value, OMFactory fac) {
        ArrayList<OMElement> arrayEl = new ArrayList<OMElement>();
        List<ParamValue> strVals = value.getArrayValue();
        for (ParamValue val : strVals) {
            OMElement el = fac.createOMElement(new QName(name));
            el.setText(val.toString());
            arrayEl.add(el);
        }
        return arrayEl;
    }

    private void processInputEvents(InternalParamCollection params) throws DataServiceFault {
        EventTrigger inputEventTrigger = this.getInputEventTrigger();
        if (inputEventTrigger != null) {
            OMElement input = this.createOMElementFromInputParams(params);
            inputEventTrigger.execute(input, this.getQueryId());
        }
    }

    public abstract void runQuery(XMLStreamWriter var1, InternalParamCollection var2, int var3) throws DataServiceFault;

    public void writeResultEntry(XMLStreamWriter xmlWriter, DataEntry dataEntry, InternalParamCollection ipc, int queryLevel) throws DataServiceFault {
        ++queryLevel;
        ExternalParamCollection params = this.createExternalParamCollection(dataEntry, ipc);
        if (this.isWriteRow()) {
            try {
                this.startRowElement(xmlWriter, this.getResult().getRowName(), this.getResult().getResultType(), this.getResult(), params);
            }
            catch (XMLStreamException e) {
                throw new DataServiceFault(e, "Error in start write row at Query.writeResultEntry");
            }
        }
        this.getResult().getDefaultElementGroup().execute(xmlWriter, params, queryLevel);
        if (this.isWriteRow()) {
            try {
                this.endElement(xmlWriter);
            }
            catch (XMLStreamException e) {
                throw new DataServiceFault(e, "Error in end write row at Query.writeResultEntry");
            }
        }
    }

    private ExternalParamCollection createExternalParamCollection(DataEntry dataEntry, InternalParamCollection queryParams) {
        ExternalParamCollection pc = new ExternalParamCollection();
        for (String name : dataEntry.getNames()) {
            pc.addParam(new ExternalParam(name.toLowerCase(), dataEntry.getValue(name), "column"));
        }
        for (InternalParam iParam : queryParams.getParams()) {
            pc.addParam(new ExternalParam(iParam.getName().toLowerCase(), iParam.getValue(), "query-param"));
        }
        return pc;
    }
}

