/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.boxcarring;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TLConnectionStore {
    private static final Log log = LogFactory.getLog(TLConnectionStore.class);
    private static ThreadLocal<Map<String, Connection>> tlCons = new ThreadLocal<Map<String, Connection>>(){

        @Override
        protected synchronized Map<String, Connection> initialValue() {
            return new HashMap<String, Connection>();
        }
    };

    private static String generateConnectionMapId(String confidId, String user) {
        String userSuffix = user != null ? " # " + user : " # #NULL#";
        return confidId + userSuffix;
    }

    public static void addConnection(String configId, String user, Connection connection) {
        Map<String, Connection> conns = tlCons.get();
        conns.put(TLConnectionStore.generateConnectionMapId(configId, user), connection);
    }

    public static Connection getConnection(String configId, String user) {
        Map<String, Connection> conns = tlCons.get();
        return conns.get(TLConnectionStore.generateConnectionMapId(configId, user));
    }

    public static void commitAll() throws SQLException {
        Map<String, Connection> conns;
        if (log.isDebugEnabled()) {
            log.debug((Object)"TLConnectionStore.commitAll()");
        }
        if ((conns = tlCons.get()) != null) {
            for (Connection conn : conns.values()) {
                conn.commit();
                if (conn.isClosed()) continue;
                conn.close();
            }
            conns.clear();
        }
    }

    public static void rollbackAllAndClose() {
        Map<String, Connection> conns;
        if (log.isDebugEnabled()) {
            log.debug((Object)"TLConnectionStore.rollbackAllAndClose()");
        }
        if ((conns = tlCons.get()) != null) {
            for (Connection conn : conns.values()) {
                try {
                    if (conn.isClosed()) continue;
                    conn.rollback();
                    conn.close();
                }
                catch (Exception e) {
                    log.error((Object)"Error in rollbackAllAndClose", (Throwable)e);
                }
            }
            conns.clear();
        }
    }
}

