/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.boxcarring;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.commons.io.output.NullOutputStream;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.dispatch.DataServiceRequest;

public class RequestBox {
    private List<DataServiceRequest> requests = new ArrayList<DataServiceRequest>();

    public List<DataServiceRequest> getRequests() {
        return this.requests;
    }

    public void addRequest(DataServiceRequest request) {
        this.getRequests().add(request);
    }

    public void clear() {
        this.getRequests().clear();
    }

    public synchronized OMElement execute() throws DataServiceFault {
        List<DataServiceRequest> reqList = this.getRequests();
        int n = reqList.size();
        for (int i = 0; i < n; ++i) {
            OMElement result = reqList.get(i).dispatch();
            if (result == null) continue;
            try {
                if (i == n - 1) {
                    return DBUtils.cloneAndReturnBuiltElement(result);
                }
                result.serializeAndConsume((OutputStream)new NullOutputStream());
                continue;
            }
            catch (XMLStreamException e) {
                throw new DataServiceFault(e, "Error in request box result serializing");
            }
        }
        return null;
    }
}

