/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.jaxp.OMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.registry.core.service.RegistryService;

public class XSLTTransformer {
    private static final Log log = LogFactory.getLog(DBUtils.class);
    private String xsltPath;
    private Transformer transformer;
    private XMLInputFactory xmlInputFactory;

    public XSLTTransformer(String xsltPath) throws TransformerConfigurationException, DataServiceFault, IOException {
        this.xsltPath = xsltPath;
        if (!xsltPath.startsWith("conf:") && !xsltPath.startsWith("gov:")) {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            this.transformer = tFactory.newTransformer(new StreamSource(DBUtils.getInputStreamFromPath(this.getXsltPath())));
        }
        this.xmlInputFactory = DBUtils.getXMLInputFactory();
    }

    public void setRegistryService(RegistryService registryService) {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            this.transformer = tFactory.newTransformer(new StreamSource(DBUtils.getInputStreamFromPath(this.getXsltPath())));
        }
        catch (Exception e) {
            log.error((Object)"Error getting XSLT path from the registry", (Throwable)e);
        }
    }

    public String getXsltPath() {
        return this.xsltPath;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public XMLInputFactory getXmlInputFactory() {
        return this.xmlInputFactory;
    }

    public OMElement transform(OMElement inputXML) throws DataServiceFault {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            OMSource xmlSource = new OMSource(inputXML);
            if (this.getTransformer() == null) {
                throw new DataServiceFault("XSLT transformer not initialized");
            }
            this.getTransformer().transform((Source)xmlSource, new StreamResult(outputStream));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            XMLStreamReader reader = this.getXmlInputFactory().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            return builder.getDocumentElement();
        }
        catch (Exception e) {
            String msg = "Error in transforming with XSLT: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new DataServiceFault(e, msg);
        }
    }
}

