/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.ui.beans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.dataservices.ui.beans.Attribute;
import org.wso2.carbon.dataservices.ui.beans.CallQuery;
import org.wso2.carbon.dataservices.ui.beans.CallQueryGroup;
import org.wso2.carbon.dataservices.ui.beans.ComplexElement;
import org.wso2.carbon.dataservices.ui.beans.DataServiceConfigurationElement;
import org.wso2.carbon.dataservices.ui.beans.Element;
import org.wso2.carbon.dataservices.ui.beans.RDFResource;

public class Result
extends DataServiceConfigurationElement {
    private String resultWrapper = "";
    private String rowName = "";
    private String outputType = "";
    private String useColumnNumbers = "false";
    private String namespace = "";
    private String rdfBaseURI = "";
    private String userRole = "";
    private List<ComplexElement> complexElements = new ArrayList<ComplexElement>();
    private List<RDFResource> resources = new ArrayList<RDFResource>();
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private List<CallQueryGroup> callQueryGroups = new ArrayList<CallQueryGroup>();
    private List<Element> elements = new ArrayList<Element>();
    private String[] resultSetColumnNames;
    private String[] displayColumnNames;
    private String[] elementLocalNames;
    private String mappingType;
    private String xsltPath;

    public List<Element> getElements() {
        return this.elements;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public void removeElement(Element element) {
        this.elements.remove(element);
    }

    public void addElement(Element element) {
        this.elements.add(element);
    }

    public List<ComplexElement> getComplexElements() {
        return this.complexElements;
    }

    public void setComplexElements(List<ComplexElement> complexElements) {
        this.complexElements = complexElements;
    }

    public void addComplexElement(ComplexElement complexElement) {
        this.complexElements.add(complexElement);
    }

    public void removeElement(ComplexElement complexElement) {
        this.complexElements.remove(complexElement);
    }

    public List<RDFResource> getResources() {
        return this.resources;
    }

    public void setResources(List<RDFResource> resource) {
        this.resources = resource;
    }

    public void removeResource(RDFResource resource) {
        this.resources.remove(resource);
    }

    public void addResources(RDFResource resource) {
        this.resources.add(resource);
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void removeAttribute(Attribute attribute) {
        this.attributes.remove(attribute);
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public List<CallQueryGroup> getCallQueryGroups() {
        return this.callQueryGroups;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String getUseColumnNumbers() {
        return this.useColumnNumbers;
    }

    public void setUseColumnNumbers(String useColumnNumbers) {
        this.useColumnNumbers = useColumnNumbers;
    }

    public String getRdfBaseURI() {
        return this.rdfBaseURI;
    }

    public void setRdfBaseURI(String rdfBaseURI) {
        this.rdfBaseURI = rdfBaseURI;
    }

    public List<CallQuery> getCallQueries() {
        ArrayList<CallQuery> list = new ArrayList<CallQuery>();
        for (CallQueryGroup callQueryGroup : this.getCallQueryGroups()) {
            if (callQueryGroup.getCallQueries().size() != 1) continue;
            list.add(callQueryGroup.getCallQueries().get(0));
        }
        return list;
    }

    public void removeCallQueries(CallQuery callQuery) {
        Iterator<CallQueryGroup> cqItr = this.getCallQueryGroups().iterator();
        CallQueryGroup callQueryGroup = null;
        while (cqItr.hasNext()) {
            callQueryGroup = cqItr.next();
            if (callQueryGroup.getCallQueries().size() != 1 || !callQueryGroup.getCallQueries().get(0).equals(callQuery)) continue;
            cqItr.remove();
            break;
        }
    }

    public Element removeElement(String elementName) {
        Element element = new Element();
        for (int a = 0; a < this.elements.size(); ++a) {
            element = this.elements.get(a);
            if (!element.getName().equals(elementName)) continue;
            element = this.elements.remove(a);
        }
        return element;
    }

    public ComplexElement removeComplexElement(String elementName) {
        ComplexElement element = new ComplexElement();
        for (int a = 0; a < this.complexElements.size(); ++a) {
            element = this.complexElements.get(a);
            if (!element.getName().equals(elementName)) continue;
            element = this.complexElements.remove(a);
        }
        return element;
    }

    public ComplexElement getChild(String path) {
        return this.getChild(this.getComplexElements(), this.getTokens(path));
    }

    public List<String> getTokens(String path) {
        String[] children = path.split("/");
        ArrayList<String> pathTokens = new ArrayList<String>();
        for (String val : children) {
            if (val.length() <= 0) continue;
            pathTokens.add(val);
        }
        return pathTokens;
    }

    public ComplexElement getChild(List<ComplexElement> elementList, List<String> pathTokens) {
        for (ComplexElement el : elementList) {
            if (pathTokens.size() <= 0 || !el.getName().equals(pathTokens.get(0))) continue;
            if (pathTokens.size() == 1) {
                return el;
            }
            if (pathTokens.size() <= 1) continue;
            return this.getChild(el.getComplexElements(), new ArrayList<String>(pathTokens).subList(1, pathTokens.size()));
        }
        return null;
    }

    public void removeChild(String path) {
        Iterator<ComplexElement> itr;
        List<String> tokens = this.getTokens(path);
        if (tokens.size() == 0) {
            return;
        }
        if (tokens.size() == 1) {
            itr = this.getComplexElements().iterator();
        } else {
            ComplexElement parent = this.getChild(this.getComplexElements(), tokens.subList(0, tokens.size() - 1));
            itr = parent.getComplexElements().iterator();
        }
        String childToken = tokens.get(tokens.size() - 1);
        while (itr.hasNext()) {
            if (!itr.next().getName().equals(childToken)) continue;
            itr.remove();
            return;
        }
    }

    public ComplexElement getComplexElement(String elementName) {
        ComplexElement retrievElement = null;
        ComplexElement complexElement = new ComplexElement();
        for (int a = 0; a < this.complexElements.size(); ++a) {
            complexElement = this.complexElements.get(a);
            if (complexElement == null || !complexElement.getName().equals(elementName)) continue;
            retrievElement = complexElement;
        }
        return retrievElement;
    }

    public RDFResource removeResource(String resourceName) {
        RDFResource resource = new RDFResource();
        for (int a = 0; a < this.resources.size(); ++a) {
            resource = this.resources.get(a);
            if (!resource.getName().equals(resourceName)) continue;
            resource = this.resources.remove(a);
        }
        return resource;
    }

    public Attribute removeAttribute(String attributeName) {
        Attribute attribute = new Attribute();
        for (int a = 0; a < this.attributes.size(); ++a) {
            attribute = this.attributes.get(a);
            if (!attribute.getName().equals(attributeName)) continue;
            attribute = this.attributes.remove(a);
        }
        return attribute;
    }

    public void removeCallQuery(String href) {
        CallQuery callQuery = null;
        CallQueryGroup callQueryGroup = null;
        Iterator<CallQueryGroup> callQueryGroupsItr = this.getCallQueryGroups().iterator();
        while (callQueryGroupsItr.hasNext()) {
            callQueryGroup = callQueryGroupsItr.next();
            if (callQueryGroup.getCallQueries().size() != 1 || !(callQuery = callQueryGroup.getCallQueries().get(0)).getHref().equals(href)) continue;
            callQueryGroupsItr.remove();
            break;
        }
    }

    public void removeCallQueryGroup(CallQueryGroup callQueryGroup) {
        this.getCallQueryGroups().remove(callQueryGroup);
    }

    public void setCallQueryGroups(List<CallQueryGroup> callQueryGroups) {
        this.callQueryGroups = callQueryGroups;
    }

    public void setCallQueries(List<CallQuery> callQueries) {
        this.callQueryGroups = new ArrayList<CallQueryGroup>();
        for (CallQuery callQuery : callQueries) {
            this.addCallQuery(callQuery);
        }
    }

    public void addCallQueryGroup(CallQueryGroup callQueryGroup) {
        this.callQueryGroups.add(callQueryGroup);
    }

    public void addCallQuery(CallQuery callQuery) {
        CallQueryGroup callQueryGroup = new CallQueryGroup();
        callQueryGroup.addCallQuery(callQuery);
        this.addCallQueryGroup(callQueryGroup);
    }

    public String getResultWrapper() {
        return this.resultWrapper;
    }

    public void setResultWrapper(String resultWrapper) {
        this.resultWrapper = resultWrapper;
    }

    public String getRowName() {
        return this.rowName;
    }

    public void setRowName(String rowName) {
        this.rowName = rowName;
    }

    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }

    public String getUserRole() {
        return this.userRole;
    }

    public String[] getResultSetColumnNames() {
        return this.resultSetColumnNames;
    }

    public void setResultSetColumnNames(String[] resultSetColumnNames) {
        this.resultSetColumnNames = resultSetColumnNames;
    }

    public String[] getDisplayColumnNames() {
        return this.displayColumnNames;
    }

    public void setDisplayColumnNames(String[] displayColumnNames) {
        this.displayColumnNames = displayColumnNames;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String[] getElementLocalNames() {
        return this.elementLocalNames;
    }

    public void setElementLocalNames(String[] elementLocalNames) {
        this.elementLocalNames = elementLocalNames;
    }

    public String getXsltPath() {
        return this.xsltPath;
    }

    public void setXsltPath(String xsltPath) {
        this.xsltPath = xsltPath;
    }

    public Result() {
    }

    public Result(OMElement result) {
        String wrapperElementName = result.getAttributeValue(new QName("element"));
        String rowElementName = result.getAttributeValue(new QName("rowName"));
        String outputType = result.getAttributeValue(new QName("outputType"));
        String rdfBaseURI = result.getAttributeValue(new QName("rdfBaseURI"));
        String userRole = result.getAttributeValue(new QName("userRole"));
        String useColumnNumbers = result.getAttributeValue(new QName("useColumnNumbers"));
        if (outputType == null || outputType.trim().length() == 0) {
            outputType = "xml";
        }
        if (wrapperElementName == null || wrapperElementName.trim().length() == 0) {
            wrapperElementName = "results";
        }
        if (rowElementName == null || rowElementName.trim().length() == 0) {
            rowElementName = "row";
        }
        if (useColumnNumbers == null || useColumnNumbers.trim().length() == 0) {
            useColumnNumbers = "false";
        }
        this.outputType = outputType;
        this.useColumnNumbers = useColumnNumbers;
        this.resultWrapper = wrapperElementName;
        this.rdfBaseURI = rdfBaseURI;
        this.rowName = rowElementName;
        this.userRole = userRole;
        Iterator elements = result.getChildElements();
        ArrayList<String> displayColumns = new ArrayList<String>();
        ArrayList<String> resultSetColumns = new ArrayList<String>();
        ArrayList<String> elementLclNames = new ArrayList<String>();
        while (elements.hasNext()) {
            OMElement element = (OMElement)elements.next();
            String displayTagName = element.getAttributeValue(new QName("name"));
            String resultSetFieldName = element.getAttributeValue(new QName("column"));
            displayColumns.add(displayTagName);
            resultSetColumns.add(resultSetFieldName);
            elementLclNames.add(element.getLocalName());
        }
        this.displayColumnNames = displayColumns.toArray(new String[displayColumns.size()]);
        this.resultSetColumnNames = resultSetColumns.toArray(new String[resultSetColumns.size()]);
        this.elementLocalNames = elementLclNames.toArray(new String[elementLclNames.size()]);
    }

    public String getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(String mappingType) {
        if (mappingType.equals("attribute")) {
            Attribute attribute = new Attribute();
            attribute.buildXML();
        } else if (mappingType.equals("element")) {
            Element element = new Element();
            element.buildXML();
        } else if (mappingType.equals("query")) {
            CallQuery query = new CallQuery();
            query.buildXML();
        }
    }

    @Override
    public OMElement buildXML() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement resEl = fac.createOMElement("result", null);
        if (this.getOutputType() != null && !this.getOutputType().equals("xml") && this.outputType.trim().length() > 1) {
            resEl.addAttribute("outputType", this.getOutputType(), null);
        }
        if (this.getOutputType().equals("xml") || this.getOutputType().equals("")) {
            if (this.getResultWrapper() != null) {
                resEl.addAttribute("element", this.getResultWrapper(), null);
            }
            if (this.getRowName() != null) {
                resEl.addAttribute("rowName", this.getRowName(), null);
            }
        }
        if (this.getOutputType().equals("rdf") && this.getRdfBaseURI() != null) {
            resEl.addAttribute("rdfBaseURI", this.getRdfBaseURI(), null);
        }
        if (this.getNamespace() != null && !this.getNamespace().equals("")) {
            resEl.addAttribute("defaultNamespace", this.getNamespace(), null);
        }
        if (this.getXsltPath() != null) {
            resEl.addAttribute("xsltPath", this.getXsltPath(), null);
        }
        if (this.getUseColumnNumbers() != null && this.getUseColumnNumbers().equals("true")) {
            resEl.addAttribute("useColumnNumbers", this.getUseColumnNumbers(), null);
        }
        for (Element element : this.getElements()) {
            resEl.addChild((OMNode)element.buildXML());
        }
        for (ComplexElement complexElement : this.getComplexElements()) {
            resEl.addChild((OMNode)complexElement.buildXML());
        }
        for (RDFResource resource : this.getResources()) {
            resEl.addChild((OMNode)resource.buildXML());
        }
        for (Attribute attribute : this.getAttributes()) {
            resEl.addChild((OMNode)attribute.buildXML());
        }
        for (CallQueryGroup callQueryGroup : this.getCallQueryGroups()) {
            resEl.addChild((OMNode)callQueryGroup.buildXML());
        }
        return resEl;
    }
}

