/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core.describe;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.core.describe.DescribeHandler;
import com.hp.hpl.jena.sparql.util.Closure;
import com.hp.hpl.jena.sparql.util.Context;

public class DescribeBNodeClosure
implements DescribeHandler {
    Model acc;
    Dataset dataset;
    private static Query query = QueryFactory.create("SELECT ?g { GRAPH ?g { ?s ?p ?o } }");

    public void start(Model accumulateResultModel, Context cxt) {
        this.acc = accumulateResultModel;
        this.dataset = (Dataset)cxt.get(ARQConstants.sysCurrentDataset);
    }

    public void describe(Resource r) {
        Closure.closure(DescribeBNodeClosure.otherModel(r, this.dataset.getDefaultModel()), false, this.acc);
        QuerySolutionMap qsm = new QuerySolutionMap();
        qsm.add("s", r);
        QueryExecution qExec = QueryExecutionFactory.create(query, this.dataset, (QuerySolution)qsm);
        ResultSet rs = qExec.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            String gName = qs.getResource("g").getURI();
            Model model = this.dataset.getNamedModel(gName);
            Resource r2 = DescribeBNodeClosure.otherModel(r, model);
            Closure.closure(r2, false, this.acc);
        }
        Closure.closure(r, false, this.acc);
    }

    private static Resource otherModel(Resource r, Model model) {
        if (r.isURIResource()) {
            return model.createResource(r.getURI());
        }
        if (r.isAnon()) {
            return model.createResource(r.getId());
        }
        return r;
    }

    public void finish() {
    }
}

