/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.Binding1;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.path.PathLib;

public class Substitute {
    public static Op substitute(Op op, Binding binding) {
        if (Substitute.isNotNeeded(binding)) {
            return op;
        }
        return Transformer.transform(new OpSubstituteWorker(binding), op);
    }

    public static Op substitute(Op op, Var var, Node node) {
        Binding1 b = new Binding1(null, var, node);
        return Substitute.substitute(op, (Binding)b);
    }

    public static BasicPattern substitute(BasicPattern bgp, Binding binding) {
        if (Substitute.isNotNeeded(binding)) {
            return bgp;
        }
        BasicPattern bgp2 = new BasicPattern();
        for (Triple triple : bgp) {
            Triple t = Substitute.substitute(triple, binding);
            bgp2.add(t);
        }
        return bgp2;
    }

    public static Triple substitute(Triple triple, Binding binding) {
        if (Substitute.isNotNeeded(binding)) {
            return triple;
        }
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        Node s1 = Substitute.substitute(s, binding);
        Node p1 = Substitute.substitute(p, binding);
        Node o1 = Substitute.substitute(o, binding);
        Triple t = triple;
        if (s1 != s || p1 != p || o1 != o) {
            t = new Triple(s1, p1, o1);
        }
        return t;
    }

    public static Node substitute(Node n, Binding b) {
        return Var.lookup(b, n);
    }

    private static boolean isNotNeeded(Binding b) {
        return b.isEmpty();
    }

    private static class OpSubstituteWorker
    extends TransformCopy {
        private Binding binding;

        public OpSubstituteWorker(Binding binding) {
            super(true);
            this.binding = binding;
        }

        public Op transform(OpBGP opBGP) {
            BasicPattern bgp = opBGP.getPattern();
            bgp = Substitute.substitute(bgp, this.binding);
            return new OpBGP(bgp);
        }

        public Op transform(OpQuadPattern quadPattern) {
            Node gNode = quadPattern.getGraphNode();
            Node g = Substitute.substitute(gNode, this.binding);
            BasicPattern triples = new BasicPattern();
            for (Triple triple : quadPattern.getBasicPattern()) {
                Node s = Substitute.substitute(triple.getSubject(), this.binding);
                Node p = Substitute.substitute(triple.getPredicate(), this.binding);
                Node o = Substitute.substitute(triple.getObject(), this.binding);
                Triple t = new Triple(s, p, o);
                triples.add(t);
            }
            return new OpQuadPattern(g, triples);
        }

        public Op transform(OpPath opPath) {
            return new OpPath(PathLib.substitute(opPath.getTriplePath(), this.binding));
        }

        public Op transform(OpFilter filter, Op op) {
            ExprList exprs = filter.getExprs().copySubstitute(this.binding, true);
            return OpFilter.filter(exprs, op);
        }

        public Op transform(OpAssign opAssign, Op subOp) {
            VarExprList varExprList2 = new VarExprList();
            for (Var v : opAssign.getVarExprList().getVars()) {
                Expr expr = opAssign.getVarExprList().getExpr(v);
                expr = expr.copySubstitute(this.binding, true);
                varExprList2.add(v, expr);
            }
            if (varExprList2.isEmpty()) {
                return subOp;
            }
            return OpAssign.assign(subOp, varExprList2);
        }

        public Op transform(OpGraph op, Op sub) {
            Node n = Substitute.substitute(op.getNode(), this.binding);
            return new OpGraph(n, sub);
        }

        public Op transform(OpService op, Op sub) {
            Node n = Substitute.substitute(op.getService(), this.binding);
            return new OpService(n, sub);
        }
    }
}

