/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockMRSW;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetGraphOpen
implements DatasetGraph {
    private Context context = new Context();
    private Map<Node, Graph> graphs = new HashMap<Node, Graph>();
    private Graph defaultGraph;
    private GraphMaker graphMaker;
    private Lock lock = new LockMRSW();

    public DatasetGraphOpen(GraphMaker graphMaker) {
        this.graphMaker = graphMaker;
        this.defaultGraph = graphMaker.create();
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return true;
    }

    @Override
    public Graph getDefaultGraph() {
        return this.defaultGraph;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        Graph g = this.graphs.get(graphNode);
        if (g == null) {
            g = this.graphMaker.create();
            this.graphs.put(graphNode, g);
        }
        return g;
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.graphs.keySet().iterator();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public int size() {
        return this.graphs.size();
    }

    @Override
    public void close() {
    }

    public static interface GraphMaker {
        public Graph create();
    }
}

