/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockMRSW;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.lib.Cache;
import com.hp.hpl.jena.sparql.lib.CacheFactory;
import com.hp.hpl.jena.sparql.util.Context;

public abstract class DatasetGraphBase
implements DatasetGraph {
    private final Lock lock = new LockMRSW();
    private Context context = new Context();
    private final boolean caching = true;
    protected Graph defaultGraph = null;
    protected Cache<Node, Graph> namedGraphs = CacheFactory.createCache(100);

    protected abstract void _close();

    protected abstract Graph _createNamedGraph(Node var1);

    protected abstract Graph _createDefaultGraph();

    protected abstract boolean _containsGraph(Node var1);

    protected DatasetGraphBase() {
    }

    public boolean containsGraph(Node graphNode) {
        if (this.namedGraphs.containsKey(graphNode)) {
            return true;
        }
        return this._containsGraph(graphNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Graph getDefaultGraph() {
        DatasetGraphBase datasetGraphBase = this;
        synchronized (datasetGraphBase) {
            if (this.defaultGraph == null) {
                this.defaultGraph = this._createDefaultGraph();
            }
        }
        return this.defaultGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Graph getGraph(Node graphNode) {
        DatasetGraphBase datasetGraphBase = this;
        synchronized (datasetGraphBase) {
            Graph graph = this.namedGraphs.get(graphNode);
            if (graph == null) {
                graph = this._createNamedGraph(graphNode);
                this.namedGraphs.put(graphNode, graph);
            }
            return graph;
        }
    }

    public Lock getLock() {
        return this.lock;
    }

    public Context getContext() {
        return this.context;
    }

    public final void close() {
        this.defaultGraph = null;
        this.namedGraphs.clear();
        this._close();
    }
}

