/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class Aggregate
extends SystemFunction {
    public static final int SUM = 0;
    public static final int AVG = 1;
    public static final int COUNT = 4;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(optimizer, this.argument[0], true);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        switch (this.operation) {
            case 4: {
                return super.getItemType(typeHierarchy);
            }
            case 0: {
                ItemType itemType = Atomizer.getAtomizedItemType(this.argument[0], false, typeHierarchy);
                if (itemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    itemType = BuiltInAtomicType.DOUBLE;
                }
                if (Cardinality.allowsZero(this.argument[0].getCardinality())) {
                    if (this.argument.length == 1) {
                        return Type.getCommonSuperType(itemType, BuiltInAtomicType.INTEGER, typeHierarchy);
                    }
                    return Type.getCommonSuperType(itemType, this.argument[1].getItemType(typeHierarchy), typeHierarchy);
                }
                return itemType;
            }
            case 1: {
                ItemType itemType = Atomizer.getAtomizedItemType(this.argument[0], false, typeHierarchy);
                if (itemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    return BuiltInAtomicType.DOUBLE;
                }
                if (itemType.getPrimitiveType() == 532) {
                    return BuiltInAtomicType.DECIMAL;
                }
                return itemType;
            }
        }
        throw new AssertionError((Object)"Unknown aggregate operation");
    }

    public int computeCardinality() {
        if (this.operation == 1 && !Cardinality.allowsZero(this.argument[0].getCardinality())) {
            return 16384;
        }
        return super.computeCardinality();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        switch (this.operation) {
            case 4: {
                SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
                return new Int64Value(Aggregate.count(sequenceIterator));
            }
            case 0: {
                AtomicValue atomicValue = Aggregate.total(this.argument[0].iterate(xPathContext), xPathContext, this);
                if (atomicValue != null) {
                    return atomicValue;
                }
                if (this.argument.length == 2) {
                    return (AtomicValue)this.argument[1].evaluateItem(xPathContext);
                }
                return Int64Value.ZERO;
            }
            case 1: {
                return Aggregate.average(this.argument[0].iterate(xPathContext), xPathContext, this);
            }
        }
        throw new UnsupportedOperationException("Unknown aggregate function");
    }

    public static AtomicValue total(SequenceIterator sequenceIterator, XPathContext xPathContext, SourceLocator sourceLocator) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)sequenceIterator.next();
        if (atomicValue == null) {
            return null;
        }
        if (atomicValue instanceof UntypedAtomicValue) {
            try {
                atomicValue = atomicValue.convert(BuiltInAtomicType.DOUBLE, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null || xPathException.getLocator().getLineNumber() == -1) {
                    xPathException.setLocator(sourceLocator);
                }
                throw xPathException;
            }
        }
        if (atomicValue instanceof NumericValue) {
            AtomicValue atomicValue2;
            do {
                if ((atomicValue2 = (AtomicValue)sequenceIterator.next()) == null) {
                    return atomicValue;
                }
                if (atomicValue2 instanceof UntypedAtomicValue) {
                    atomicValue2 = atomicValue2.convert(BuiltInAtomicType.DOUBLE, xPathContext);
                    continue;
                }
                if (atomicValue2 instanceof NumericValue) continue;
                DynamicError dynamicError = new DynamicError("Input to sum() contains a mix of numeric and non-numeric values");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setErrorCode("FORG0006");
                dynamicError.setLocator(sourceLocator);
                throw dynamicError;
            } while (!((NumericValue)(atomicValue = ((NumericValue)atomicValue).arithmetic(15, (NumericValue)atomicValue2, xPathContext))).isNaN());
            return atomicValue;
        }
        if (atomicValue instanceof DurationValue) {
            while (true) {
                AtomicValue atomicValue3;
                if ((atomicValue3 = (AtomicValue)sequenceIterator.next()) == null) {
                    return atomicValue;
                }
                if (!(atomicValue3 instanceof DurationValue)) {
                    DynamicError dynamicError = new DynamicError("Input to sum() contains a mix of duration and non-duration values");
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setErrorCode("FORG0006");
                    dynamicError.setLocator(sourceLocator);
                    throw dynamicError;
                }
                atomicValue = ((DurationValue)atomicValue).add((DurationValue)atomicValue3);
            }
        }
        DynamicError dynamicError = new DynamicError("Input to sum() contains a value that is neither numeric, nor a duration");
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode("FORG0006");
        dynamicError.setLocator(sourceLocator);
        throw dynamicError;
    }

    public static AtomicValue average(SequenceIterator sequenceIterator, XPathContext xPathContext, SourceLocator sourceLocator) throws XPathException {
        int n = 0;
        AtomicValue atomicValue = (AtomicValue)sequenceIterator.next();
        if (atomicValue == null) {
            return null;
        }
        ++n;
        if (atomicValue instanceof UntypedAtomicValue) {
            try {
                atomicValue = atomicValue.convert(BuiltInAtomicType.DOUBLE, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null || xPathException.getLocator().getLineNumber() == -1) {
                    xPathException.setLocator(sourceLocator);
                }
                throw xPathException;
            }
        }
        if (atomicValue instanceof NumericValue) {
            AtomicValue atomicValue2;
            do {
                if ((atomicValue2 = (AtomicValue)sequenceIterator.next()) == null) {
                    return ((NumericValue)atomicValue).arithmetic(18, new Int64Value(n), xPathContext);
                }
                ++n;
                if (atomicValue2 instanceof UntypedAtomicValue) {
                    try {
                        atomicValue2 = atomicValue2.convert(BuiltInAtomicType.DOUBLE, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null || xPathException.getLocator().getLineNumber() == -1) {
                            xPathException.setLocator(sourceLocator);
                        }
                        throw xPathException;
                    }
                } else {
                    if (atomicValue2 instanceof NumericValue) continue;
                    DynamicError dynamicError = new DynamicError("Input to avg() contains a mix of numeric and non-numeric values");
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setErrorCode("FORG0006");
                    dynamicError.setLocator(sourceLocator);
                    throw dynamicError;
                }
            } while (!((NumericValue)(atomicValue = ((NumericValue)atomicValue).arithmetic(15, (NumericValue)atomicValue2, xPathContext))).isNaN());
            return atomicValue;
        }
        if (atomicValue instanceof DurationValue) {
            while (true) {
                AtomicValue atomicValue3;
                if ((atomicValue3 = (AtomicValue)sequenceIterator.next()) == null) {
                    return ((DurationValue)atomicValue).multiply(1.0 / (double)n);
                }
                ++n;
                if (!(atomicValue3 instanceof DurationValue)) {
                    DynamicError dynamicError = new DynamicError("Input to avg() contains a mix of duration and non-duration values");
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setErrorCode("FORG0006");
                    dynamicError.setLocator(sourceLocator);
                    throw dynamicError;
                }
                atomicValue = ((DurationValue)atomicValue).add((DurationValue)atomicValue3);
            }
        }
        DynamicError dynamicError = new DynamicError("Input to avg() contains a value that is neither numeric, nor a duration");
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode("FORG0006");
        dynamicError.setLocator(sourceLocator);
        throw dynamicError;
    }

    public static int count(SequenceIterator sequenceIterator) throws XPathException {
        if ((sequenceIterator.getProperties() & 2) != 0) {
            return ((LastPositionFinder)sequenceIterator).getLastPosition();
        }
        int n = 0;
        while (sequenceIterator.next() != null) {
            ++n;
        }
        return n;
    }

    public static boolean isCountFunction(Expression expression) {
        if (!(expression instanceof Aggregate)) {
            return false;
        }
        Aggregate aggregate = (Aggregate)expression;
        return aggregate.getNumberOfArguments() == 1 && aggregate.operation == 4;
    }
}

