/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransientConnectionException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql.jdbc.CassandraConnection;
import org.apache.cassandra.cql.jdbc.CassandraResultSet;
import org.apache.cassandra.cql.jdbc.CassandraStatement;
import org.apache.cassandra.cql.jdbc.HandleObjects;
import org.apache.cassandra.cql.jdbc.JdbcBoolean;
import org.apache.cassandra.cql.jdbc.JdbcDate;
import org.apache.cassandra.cql.jdbc.JdbcDecimal;
import org.apache.cassandra.cql.jdbc.JdbcDouble;
import org.apache.cassandra.cql.jdbc.JdbcFloat;
import org.apache.cassandra.cql.jdbc.JdbcInt32;
import org.apache.cassandra.cql.jdbc.JdbcInteger;
import org.apache.cassandra.cql.jdbc.JdbcLong;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraPreparedStatement
extends CassandraStatement
implements PreparedStatement {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraPreparedStatement.class);
    private int itemId;
    private int count;
    private Map<Integer, ByteBuffer> bindValues = new LinkedHashMap<Integer, ByteBuffer>();

    CassandraPreparedStatement(CassandraConnection con, String cql) throws SQLException {
        super(con, cql);
        if (LOG.isTraceEnabled()) {
            LOG.trace("CQL: " + this.cql);
        }
        try {
            CqlPreparedResult result = con.prepare(cql);
            this.itemId = result.itemId;
            this.count = result.count;
        }
        catch (InvalidRequestException e) {
            throw new SQLSyntaxErrorException(e);
        }
        catch (TException e) {
            throw new SQLNonTransientConnectionException(e);
        }
    }

    private final void checkIndex(int index) throws SQLException {
        if (index > this.count) {
            throw new SQLRecoverableException(String.format("the column index : %d is greater than the count of bound variable markers in the CQL: %d", index, this.count));
        }
        if (index < 1) {
            throw new SQLRecoverableException(String.format("the column index must be a positive number : %d", index));
        }
    }

    private List<ByteBuffer> getBindValues() throws SQLException {
        ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>();
        if (this.bindValues.size() != this.count) {
            throw new SQLRecoverableException(String.format("the number of bound variables: %d must match the count of bound variable markers in the CQL: %d", this.bindValues.size(), this.count));
        }
        for (int i = 1; i <= this.count; ++i) {
            ByteBuffer value = this.bindValues.get(i);
            if (value == null) {
                throw new SQLRecoverableException(String.format("the bound value for index: %d was not set", i));
            }
            values.add(value);
        }
        return values;
    }

    @Override
    public void close() throws SQLException {
        this.connection.removeStatement(this);
        this.connection = null;
    }

    private void doExecute() throws SQLException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("CQL: " + this.cql);
        }
        try {
            this.resetResults();
            CqlResult result = this.connection.execute(this.itemId, this.getBindValues());
            String keyspace = this.connection.currentKeyspace;
            switch (result.getType()) {
                case ROWS: {
                    this.currentResultSet = new CassandraResultSet(this, result, keyspace);
                    break;
                }
                case INT: {
                    this.updateCount = result.getNum();
                    break;
                }
                case VOID: {
                    this.updateCount = 0;
                }
            }
        }
        catch (InvalidRequestException e) {
            throw new SQLSyntaxErrorException(e.getWhy());
        }
        catch (UnavailableException e) {
            throw new SQLNonTransientConnectionException("no Cassandra server is available", e);
        }
        catch (TimedOutException e) {
            throw new SQLTransientConnectionException(e.getMessage());
        }
        catch (SchemaDisagreementException e) {
            throw new SQLRecoverableException("schema does not match across nodes, (try again later)");
        }
        catch (TException e) {
            throw new SQLNonTransientConnectionException(e.getMessage());
        }
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkNotClosed();
        this.bindValues.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkNotClosed();
        this.doExecute();
        return this.currentResultSet != null;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkNotClosed();
        this.doExecute();
        if (this.currentResultSet == null) {
            throw new SQLNonTransientException("No ResultSet returned from the CQL statement passed in an 'executeQuery()' method");
        }
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkNotClosed();
        this.doExecute();
        if (this.currentResultSet != null) {
            throw new SQLNonTransientException("No Update Count was returned from the CQL statement passed in an 'executeUpdate()' method");
        }
        return this.updateCount;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal decimal) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, JdbcDecimal.instance.decompose(decimal));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean truth) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, JdbcBoolean.instance.decompose(truth));
    }

    @Override
    public void setByte(int parameterIndex, byte b) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, JdbcInteger.instance.decompose(BigInteger.valueOf(b)));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, ByteBuffer.wrap(bytes));
    }

    @Override
    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, JdbcDate.instance.decompose(value));
    }

    @Override
    public void setDate(int parameterIndex, Date date, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, date);
    }

    @Override
    public void setDouble(int parameterIndex, double decimal) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, JdbcDouble.instance.decompose(decimal));
    }

    @Override
    public void setFloat(int parameterIndex, float decimal) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, JdbcFloat.instance.decompose(Float.valueOf(decimal)));
    }

    @Override
    public void setInt(int parameterIndex, int integer) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, JdbcInt32.instance.decompose(integer));
    }

    @Override
    public void setLong(int parameterIndex, long bigint) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, JdbcLong.instance.decompose(bigint));
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object object) throws SQLException {
        this.setObject(parameterIndex, object, 12, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object object, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, object, targetSqlType, 0);
    }

    @Override
    public final void setObject(int parameterIndex, Object object, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        ByteBuffer variable = HandleObjects.makeBytes(object, targetSqlType, scaleOrLength);
        if (variable == null) {
            throw new SQLNonTransientException("Problem mapping object to JDBC Type");
        }
        this.bindValues.put(parameterIndex, variable);
    }

    @Override
    public void setRowId(int parameterIndex, RowId value) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, ByteBuffer.wrap(value.getBytes()));
    }

    @Override
    public void setShort(int parameterIndex, short smallint) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, JdbcInteger.instance.decompose(BigInteger.valueOf(smallint)));
    }

    @Override
    public void setString(int parameterIndex, String value) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, ByteBufferUtil.bytes(value));
    }

    @Override
    public void setTime(int parameterIndex, Time value) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, JdbcLong.instance.decompose(value.getTime()));
    }

    @Override
    public void setTime(int parameterIndex, Time value, Calendar cal) throws SQLException {
        this.setTime(parameterIndex, value);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, JdbcLong.instance.decompose(value.getTime()));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, value);
    }

    @Override
    public void setURL(int parameterIndex, URL value) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        String url = value.toString();
        this.bindValues.put(parameterIndex, ByteBufferUtil.bytes(url));
    }
}

