/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.dataservices.core.internal.DSAxis2ConfigurationContextObserver;
import org.wso2.carbon.dataservices.core.internal.DSDummyService;
import org.wso2.carbon.dataservices.core.listeners.EventBrokerServiceListener;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.ndatasource.core.DataSourceService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.transaction.manager.TransactionManagerDummyService;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class DataServicesDSComponent {
    private static Log log = LogFactory.getLog(DataServicesDSComponent.class);
    private static RegistryService registryService = null;
    private static RealmService realmService = null;
    private static EventBroker eventBroker;
    private static DataSourceService dataSourceService;
    private static List<EventBrokerServiceListener> eventBrokerServiceListeners;
    private static Object dsComponentLock;

    protected void activate(ComponentContext ctxt) {
        try {
            BundleContext bundleContext = ctxt.getBundleContext();
            bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new DSAxis2ConfigurationContextObserver(), null);
            bundleContext.registerService(DSDummyService.class.getName(), (Object)new DSDummyService(), null);
            bundleContext.registerService(TransactionManagerDummyService.class.getName(), (Object)new TransactionManagerDummyService(), null);
            log.debug((Object)"Data Services bundle is activated ");
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"Data Services bundle is deactivated ");
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Registry Service");
        }
        DataServicesDSComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Registry Service");
        }
        DataServicesDSComponent.registryService = null;
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        DataServicesDSComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Realm Service");
        }
        DataServicesDSComponent.realmService = null;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    protected void setDataSourceService(DataSourceService dataSourceService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Data Sources Service");
        }
        DataServicesDSComponent.dataSourceService = dataSourceService;
    }

    protected void unsetDataSourceService(DataSourceService dataSourceService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Data Sources Service");
        }
        DataServicesDSComponent.dataSourceService = null;
    }

    public static DataSourceService getDataSourceService() {
        return dataSourceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setEventBroker(EventBroker eventBroker) {
        Object object = dsComponentLock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting the Event Broker Service");
            }
            DataServicesDSComponent.eventBroker = eventBroker;
            if (realmService != null) {
                this.doEventRealmInitiliased();
            }
        }
    }

    private void notifyEventServiceListeners() {
        for (EventBrokerServiceListener listener : eventBrokerServiceListeners) {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(listener.getTenantId());
            listener.setEventBroker(eventBroker);
            SuperTenantCarbonContext.endTenantFlow();
        }
        eventBrokerServiceListeners.clear();
    }

    private void doEventRealmInitiliased() {
        RealmService realmService = DataServicesDSComponent.getRealmService();
        try {
            SuperTenantCarbonContext.getCurrentContext().setUserRealm((UserRealm)realmService.getBootstrapRealm());
            SuperTenantCarbonContext.getCurrentContext().setUsername("wso2.system.user");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.notifyEventServiceListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetEventBroker(EventBroker eventBroker) {
        Object object = dsComponentLock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unsetting the Event Broker Service");
            }
            DataServicesDSComponent.eventBroker = null;
        }
    }

    public static EventBroker getEventBroker() {
        return eventBroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerEventBrokerServiceListener(EventBrokerServiceListener listener) {
        Object object = dsComponentLock;
        synchronized (object) {
            EventBroker eventBroker = DataServicesDSComponent.getEventBroker();
            if (eventBroker == null) {
                eventBrokerServiceListeners.add(listener);
            } else {
                listener.setEventBroker(eventBroker);
            }
        }
    }

    public static String getUsername() {
        return CarbonContextHolder.getCurrentCarbonContextHolder().getUsername();
    }

    static {
        eventBrokerServiceListeners = new ArrayList<EventBrokerServiceListener>();
        dsComponentLock = new Object();
    }
}

