/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.xa;

import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DataServiceFault;

public class DSSXATransactionManager {
    private static final Log log = LogFactory.getLog(DSSXATransactionManager.class);
    private ThreadLocal<Boolean> beginTx = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    public TransactionManager transactionManager;

    public DSSXATransactionManager(TransactionManager userTx) {
        if (userTx == null) {
            throw new RuntimeException("TransactionManager cannot be null");
        }
        this.transactionManager = userTx;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void begin() throws DataServiceFault {
        TransactionManager txManager = this.getTransactionManager();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"DXXATransactionManager.begin()");
            }
            if (this.hasNoActiveTransaction()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"transactionManager.begin()");
                }
                txManager.begin();
                this.beginTx.set(true);
            }
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error from transaction manager");
        }
    }

    public void commit() throws DataServiceFault {
        if (!this.beginTx.get().booleanValue()) {
            return;
        }
        TransactionManager txManager = this.getTransactionManager();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"transactionManager.commit()");
            }
            txManager.commit();
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error from transaction manager when committing");
        }
        finally {
            this.beginTx.set(false);
        }
    }

    public void rollback() throws DataServiceFault {
        TransactionManager txManager = this.getTransactionManager();
        try {
            if (!this.hasNoActiveTransaction()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"transactionManager.rollback()");
                }
                txManager.rollback();
            }
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error from transaction manager when rollbacking");
        }
        finally {
            this.beginTx.set(false);
        }
    }

    public boolean hasNoActiveTransaction() {
        try {
            return this.getTransactionManager().getStatus() == 6;
        }
        catch (Exception e) {
            log.error((Object)"Error at 'hasNoActiveTransaction'", (Throwable)e);
            return false;
        }
    }
}

