/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.SQLConfig;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class JNDIConfig
extends SQLConfig {
    private DataSource dataSource;

    public JNDIConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        super(dataService, configId, "JNDI", properties);
        if (!dataService.isServiceInactive()) {
            this.validateJNDIConfig();
            this.dataSource = this.createDataSource();
            try {
                this.initSQLDataSource();
            }
            catch (SQLException e) {
                throw new DataServiceFault(e, DBConstants.FaultCodes.CONNECTION_UNAVAILABLE_ERROR, e.getMessage());
            }
        }
    }

    private void validateJNDIConfig() throws DataServiceFault {
        if (DBUtils.isEmptyString(this.getProperty("jndi_resource_name"))) {
            throw new DataServiceFault("Resource name cannot be null in config '" + this.getConfigId() + "'");
        }
    }

    private DataSource createDataSource() throws DataServiceFault {
        Properties properties = new Properties();
        String username = this.getProperty("jndi_username");
        String password = DBUtils.resolvePasswordValue(this.getDataService(), this.getProperty("jndi_password"));
        String factoryClass = this.getProperty("jndi_context_class");
        String contextUrl = this.getProperty("jndi_provider_url");
        String resourceName = this.getProperty("jndi_resource_name");
        try {
            if (username != null && username.trim().length() > 0) {
                properties.setProperty("java.naming.security.principal", username.trim());
            }
            if (password != null && password.trim().length() > 0) {
                properties.setProperty("java.naming.security.credentials", password.trim());
            }
            if (factoryClass != null && factoryClass.trim().length() > 0) {
                properties.setProperty("java.naming.factory.initial", factoryClass.trim());
            }
            if (contextUrl != null && contextUrl.trim().length() > 0) {
                properties.setProperty("java.naming.provider.url", contextUrl.trim());
            }
            if (resourceName != null && resourceName.trim().length() > 0) {
                InitialContext context = new InitialContext(properties);
                DataSource dataSource = (DataSource)context.lookup(resourceName);
                return dataSource;
            }
            throw new DataServiceFault("JNDI resource name not specified.");
        }
        catch (NamingException e) {
            throw new DataServiceFault(e, "Naming error occurred while trying to retrieve JDBC Connection from JNDI tree.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSource() throws DataServiceFault {
        if (this.dataSource == null) {
            JNDIConfig jNDIConfig = this;
            synchronized (jNDIConfig) {
                if (this.dataSource == null) {
                    this.dataSource = this.createDataSource();
                }
            }
        }
        return this.dataSource;
    }

    @Override
    public boolean isStatsAvailable() {
        return false;
    }

    @Override
    public int getActiveConnectionCount() {
        return -1;
    }

    @Override
    public int getIdleConnectionCount() {
        return -1;
    }

    @Override
    public void close() {
    }
}

