/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.ui.beans;

import java.util.ArrayList;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.dataservices.ui.beans.Property;

public class XADataSource {
    private String id;
    private String className;
    private ArrayList<Property> properties = new ArrayList();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public ArrayList<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayList<Property> properties) {
        this.properties = properties;
    }

    public void addProperty(String name, Object value) {
        Property property = new Property(name, value);
        this.properties.add(property);
    }

    public void addProperty(Property property) {
        this.addProperty(property.getName(), property.getValue());
    }

    public void removeProperty(Property propertyName) {
        this.properties.remove(propertyName);
    }

    public void updateProperty(String name, String value) {
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            if (value != null) {
                property.setValue(value);
                continue;
            }
            property.setValue("");
        }
    }

    public void removeProperty(String propertyName) {
        Property property = new Property();
        for (int a = 0; a < this.properties.size(); ++a) {
            property = this.properties.get(a);
            if (!property.getName().equals(propertyName)) continue;
            this.removeProperty(property);
        }
    }

    public OMElement buildXML() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement opEl = fac.createOMElement("xa-datasource", null);
        if (this.getId() != null) {
            opEl.addAttribute("id", this.getId(), null);
        }
        if (this.getClassName() != null) {
            opEl.addAttribute("class", this.getClassName(), null);
        }
        for (Property property : this.getProperties()) {
            opEl.addChild((OMNode)property.buildXML());
        }
        return opEl;
    }
}

