/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPEventHandler;
import com.hp.hpl.jena.rdf.arp.ARPHandlers;
import com.hp.hpl.jena.rdf.arp.ARPOptions;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NTriple
implements ARPErrorNumbers {
    private static StringBuffer line = new StringBuffer();
    private static ARP arp;
    private static String xmlBase;
    private static boolean numbers;
    static StatementHandler andMeToo;
    private static final Runtime rt;
    private static int startMem;
    private static boolean[] okURIChars;

    public static void main(String[] args) {
        NTriple.mainEh(args, null, null);
    }

    public static void mainEh(String[] args, ErrorHandler eh, ARPEventHandler ap) {
        int i;
        boolean doneOne = false;
        startMem = -1;
        andMeToo = ap;
        arp = new ARP();
        ARPHandlers handlers = arp.getHandlers();
        handlers.setStatementHandler(NTriple.getSH(true));
        if (ap != null) {
            handlers.setNamespaceHandler(ap);
            handlers.setExtendedHandler(ap);
        }
        if (eh != null) {
            handlers.setErrorHandler(eh);
        }
        for (i = 0; i < args.length - 1; ++i) {
            if (args[i].startsWith("-")) {
                i += NTriple.processOpts(args[i].substring(1), args[i + 1]);
                continue;
            }
            doneOne = true;
            NTriple.process(args[i]);
        }
        if (args.length > 0) {
            if (args[i].startsWith("-")) {
                if (doneOne || NTriple.processOpts(args[i].substring(1), "100") == 1) {
                    NTriple.usage();
                }
            } else {
                doneOne = true;
                NTriple.process(args[i]);
            }
        }
        if (!doneOne) {
            NTriple.process(System.in, "http://example.org/stdin", "standard input");
        }
        if (startMem != -1) {
            rt.gc();
            System.out.println(rt.totalMemory() - rt.freeMemory() - (long)startMem);
            rt.gc();
            System.out.println(rt.totalMemory() - rt.freeMemory() - (long)startMem);
            rt.gc();
            System.out.println(rt.totalMemory() - rt.freeMemory() - (long)startMem);
            rt.gc();
            System.out.println(rt.totalMemory() - rt.freeMemory() - (long)startMem);
        }
    }

    private static StatementHandler getSH(boolean b) {
        StatementHandler rslt;
        StatementHandler statementHandler = rslt = b ? new SH(System.out) : new NoSH();
        if (andMeToo != null) {
            rslt = new TwoSH(rslt, andMeToo);
        }
        return rslt;
    }

    private static void lineNumber() {
        Locator locator;
        if (numbers && (locator = arp.getLocator()) != null) {
            NTriple.print("# " + locator.getSystemId() + ":" + locator.getLineNumber() + "(" + locator.getColumnNumber() + ")\n");
        }
    }

    static void usage() {
        System.err.println("java <class-path> " + NTriple.class.getName() + " ( [ -[xstfurR]][ -b xmlBase -[eiw] NNN[,NNN...] ] [ file ] [ url ] )... ");
        System.err.println("    All options, files and URLs can be intemingled in any order.");
        System.err.println("    They are processed from left-to-right.");
        System.err.println("    file      Converts RDF/XML file into N-triples");
        System.err.println("    url       Converts RDF/XML from URL into N-triples");
        System.err.println("    -b uri    Sets XML Base to the absolute URI.");
        System.err.println("    -r        Content is RDF (default, no embedding, rdf:RDF tag may be omitted).");
        System.err.println("    -R        RDF embedded in XML document, search for obligatory rdf:RDF start element.");
        System.err.println("    -t        No n-triple output, error checking only.");
        System.err.println("    -x        Lax mode - warnings are suppressed.");
        System.err.println("    -s        Strict mode - most warnings are errors.");
        System.err.println("    -n        Show line and column numbers.");
        System.err.println("    -u        Allow unqualified attributes (defaults to warning).");
        System.err.println("    -f        All errors are.error - report first one only.");
        System.err.println("    -b url    Sets XML Base to the absolute url.");
        System.err.println("    -e NNN[,NNN...]");
        System.err.println("              Treats numbered warning conditions as errrors.");
        System.err.println("    -w NNN[,NNN...]");
        System.err.println("              Treats numbered error conditions as warnings.");
        System.err.println("    -i NNN[,NNN...]");
        System.err.println("              Ignores numbered error/warning conditions.");
        System.exit(1);
    }

    private static int processOpts(String opts, String nextArg) {
        boolean usedNext = false;
        ARPOptions options = arp.getOptions();
        block16: for (int i = 0; i < opts.length(); ++i) {
            char opt = opts.charAt(i);
            if ("beiwD".indexOf(opt) != -1) {
                if (usedNext) {
                    NTriple.usage();
                }
                usedNext = true;
            }
            switch (opt) {
                case 'D': {
                    final int nStatements = Integer.parseInt(nextArg);
                    rt.gc();
                    rt.gc();
                    startMem = (int)(rt.totalMemory() - rt.freeMemory());
                    arp.getHandlers().setStatementHandler(new StatementHandler(){
                        int debugC = 0;

                        public void statement(AResource subj, AResource pred, AResource obj) {
                            this.statement(null, null, (ALiteral)null);
                        }

                        public void statement(AResource subj, AResource pred, ALiteral lit) {
                            if (++this.debugC % 100 == 0) {
                                System.out.println("T: " + this.debugC);
                                rt.gc();
                                System.out.println("M1: " + (rt.totalMemory() - rt.freeMemory() - (long)startMem));
                                rt.gc();
                                System.out.println("M2: " + (rt.totalMemory() - rt.freeMemory() - (long)startMem));
                            }
                            if (this.debugC == 1) {
                                rt.gc();
                                rt.gc();
                                startMem = (int)(rt.totalMemory() - rt.freeMemory());
                            }
                            if (this.debugC == nStatements) {
                                rt.gc();
                                System.err.println("Kill me now.");
                                try {
                                    Thread.sleep(200000L);
                                }
                                catch (Exception e2) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    continue block16;
                }
                case 'x': {
                    options.setLaxErrorMode();
                    continue block16;
                }
                case 's': {
                    options.setStrictErrorMode();
                    continue block16;
                }
                case 't': {
                    arp.getHandlers().setStatementHandler(NTriple.getSH(false));
                    continue block16;
                }
                case 'r': {
                    options.setEmbedding(false);
                    continue block16;
                }
                case 'R': {
                    options.setEmbedding(true);
                    continue block16;
                }
                case 'n': {
                    numbers = true;
                    continue block16;
                }
                case 'E': {
                    arp.getHandlers().setErrorHandler(new ErrorHandler(){

                        public void warning(SAXParseException exception) {
                        }

                        public void error(SAXParseException exception) {
                        }

                        public void fatalError(SAXParseException exception) {
                        }
                    });
                    arp.setBadStatementHandler(new SH(System.err));
                    continue block16;
                }
                case 'b': {
                    xmlBase = nextArg;
                    continue block16;
                }
                case 'e': {
                    NTriple.setErrorMode(nextArg, 2);
                    continue block16;
                }
                case 'i': {
                    NTriple.setErrorMode(nextArg, 0);
                    continue block16;
                }
                case 'w': {
                    NTriple.setErrorMode(nextArg, 1);
                    continue block16;
                }
                case 'f': {
                    for (int j = 0; j < 400; ++j) {
                        if (options.setErrorMode(j, -1) != 2) continue;
                        options.setErrorMode(j, 3);
                    }
                    continue block16;
                }
                case 'u': {
                    options.setErrorMode(102, 0);
                    options.setErrorMode(101, 0);
                    continue block16;
                }
                default: {
                    NTriple.usage();
                }
            }
        }
        return usedNext ? 1 : 0;
    }

    private static void setErrorMode(String numbers, int mode) {
        int[] n = new int[3];
        int j = 0;
        numbers = numbers + ",";
        block8: for (int i = 0; i < numbers.length(); ++i) {
            char c = numbers.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (j == 3) {
                        NTriple.usage();
                    }
                    n[j++] = c - 48;
                    continue block8;
                }
                case ' ': 
                case ',': 
                case ';': {
                    if (i == 0) {
                        NTriple.usage();
                    }
                    switch (j) {
                        case 0: {
                            continue block8;
                        }
                        case 3: {
                            arp.getOptions().setErrorMode(n[0] * 100 + n[1] * 10 + n[2], mode);
                            j = 0;
                            continue block8;
                        }
                    }
                    NTriple.usage();
                    continue block8;
                }
                default: {
                    NTriple.usage();
                }
            }
        }
    }

    private static void process(String surl) {
        String baseURL;
        InputStream in;
        try {
            File ff = new File(surl);
            in = new FileInputStream(ff);
            URL url = ff.toURI().toURL();
            baseURL = url.toExternalForm();
            if (baseURL.startsWith("file:/") && !baseURL.startsWith("file://")) {
                baseURL = "file://" + baseURL.substring(5);
            }
        }
        catch (Exception ignore) {
            try {
                URL url = new URL(surl);
                in = url.openStream();
                baseURL = url.toExternalForm();
            }
            catch (Exception e2) {
                System.err.println("ARP: Failed to open: " + surl);
                System.err.println("    " + ParseException.formatMessage(ignore));
                System.err.println("    " + ParseException.formatMessage(e2));
                return;
            }
        }
        NTriple.process(in, baseURL, surl);
    }

    private static void process(InputStream in, String xmlBasex, String surl) {
        String xmlBasey = xmlBase == null ? xmlBasex : xmlBase;
        try {
            arp.load(in, xmlBasey);
        }
        catch (IOException e2) {
            System.err.println("Error: " + surl + ": " + ParseException.formatMessage(e2));
        }
        catch (SAXParseException e3) {
        }
        catch (SAXException sax) {
            System.err.println("Error: " + surl + ": " + ParseException.formatMessage(sax));
        }
    }

    private static void print(String s) {
        line.append(s);
    }

    private static void resource(AResource r) {
        if (r.isAnonymous()) {
            NTriple.print("_:j");
            NTriple.print(r.getAnonymousID());
            NTriple.print(" ");
        } else {
            NTriple.print("<");
            NTriple.escapeURI(r.getURI());
            NTriple.print("> ");
        }
    }

    private static void escape(String s) {
        int lg = s.length();
        block7: for (int i = 0; i < lg; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    NTriple.print("\\\\");
                    continue block7;
                }
                case '\"': {
                    NTriple.print("\\\"");
                    continue block7;
                }
                case '\n': {
                    NTriple.print("\\n");
                    continue block7;
                }
                case '\r': {
                    NTriple.print("\\r");
                    continue block7;
                }
                case '\t': {
                    NTriple.print("\\t");
                    continue block7;
                }
                default: {
                    if (ch >= ' ' && ch <= '~') {
                        line.append(ch);
                        continue block7;
                    }
                    NTriple.print("\\u");
                    String hexstr = Integer.toHexString(ch).toUpperCase();
                    for (int pad = 4 - hexstr.length(); pad > 0; --pad) {
                        NTriple.print("0");
                    }
                    NTriple.print(hexstr);
                }
            }
        }
    }

    private static void escapeURI(String s) {
        int lg = s.length();
        for (int i = 0; i < lg; ++i) {
            char ch = s.charAt(i);
            if (ch < okURIChars.length && okURIChars[ch]) {
                line.append(ch);
                continue;
            }
            NTriple.print("\\u");
            String hexstr = Integer.toHexString(ch).toUpperCase();
            for (int pad = 4 - hexstr.length(); pad > 0; --pad) {
                NTriple.print("0");
            }
            NTriple.print(hexstr);
        }
    }

    private static void literal(ALiteral l) {
        String dt;
        line.append('\"');
        NTriple.escape(((Object)l).toString());
        line.append('\"');
        String lang = l.getLang();
        if (lang != null && !lang.equals("")) {
            line.append('@');
            NTriple.print(lang);
        }
        if ((dt = l.getDatatypeURI()) != null && !dt.equals("")) {
            NTriple.print("^^<");
            NTriple.escapeURI(dt);
            line.append('>');
        }
        line.append(' ');
    }

    static {
        xmlBase = null;
        numbers = false;
        andMeToo = null;
        rt = Runtime.getRuntime();
        startMem = -1;
        okURIChars = new boolean[128];
        for (int i = 32; i < 127; ++i) {
            NTriple.okURIChars[i] = true;
        }
        NTriple.okURIChars[60] = false;
        NTriple.okURIChars[62] = false;
        NTriple.okURIChars[92] = false;
    }

    private static class SH
    implements StatementHandler {
        PrintStream out;

        SH(PrintStream out) {
            this.out = out;
        }

        public void statement(AResource subj, AResource pred, AResource obj) {
            NTriple.lineNumber();
            NTriple.resource(subj);
            NTriple.resource(pred);
            NTriple.resource(obj);
            line.append('.');
            this.out.println(line);
            line.setLength(0);
        }

        public void statement(AResource subj, AResource pred, ALiteral lit) {
            NTriple.lineNumber();
            NTriple.resource(subj);
            NTriple.resource(pred);
            NTriple.literal(lit);
            line.append('.');
            this.out.println(line);
            line.setLength(0);
        }
    }

    private static class NoSH
    implements StatementHandler {
        private NoSH() {
        }

        public void statement(AResource subj, AResource pred, AResource obj) {
        }

        public void statement(AResource subj, AResource pred, ALiteral lit) {
        }
    }

    private static class TwoSH
    implements StatementHandler {
        final StatementHandler a;
        final StatementHandler b;

        public void statement(AResource subj, AResource pred, AResource obj) {
            this.a.statement(subj, pred, obj);
            this.b.statement(subj, pred, obj);
        }

        public void statement(AResource subj, AResource pred, ALiteral lit) {
            this.a.statement(subj, pred, lit);
            this.b.statement(subj, pred, lit);
        }

        TwoSH(StatementHandler A, StatementHandler B) {
            this.a = A;
            this.b = B;
        }
    }
}

