/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors.plugins;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.runtime.processors.plugins.FtpPlugin;
import org.webharvest.runtime.processors.plugins.FtpPluginException;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class FtpRmdirPlugin
extends WebHarvestPlugin {
    public String getName() {
        return "ftp-rmdir";
    }

    public Variable executePlugin(Scraper scraper, ScraperContext context) {
        block4: {
            FtpPlugin ftpPlugin = (FtpPlugin)scraper.getRunningProcessorOfType(FtpPlugin.class);
            if (ftpPlugin != null) {
                FTPClient ftpClient = ftpPlugin.getFtpClient();
                String path = CommonUtil.nvl(this.evaluateAttribute("path", scraper), "");
                this.setProperty("Path", path);
                try {
                    boolean succ = ftpClient.removeDirectory(path);
                    if (!succ) {
                        throw new FtpPluginException("Cannot remove directory \"" + path + "\" on FTP server!");
                    }
                    break block4;
                }
                catch (IOException e) {
                    throw new FtpPluginException(e);
                }
            }
            throw new FtpPluginException("Cannot use ftp rmdir plugin out of ftp plugin context!");
        }
        return new EmptyVariable();
    }

    public String[] getValidAttributes() {
        return new String[]{"path"};
    }

    public String[] getRequiredAttributes() {
        return new String[]{"path"};
    }

    public boolean hasBody() {
        return false;
    }
}

