/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import org.webharvest.definition.BaseElementDef;
import org.webharvest.definition.CaseDef;
import org.webharvest.definition.IfDef;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.BodyProcessor;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class CaseProcessor
extends BaseProcessor {
    private CaseDef caseDef;

    public CaseProcessor(CaseDef caseDef) {
        super(caseDef);
        this.caseDef = caseDef;
    }

    public Variable execute(Scraper scraper, ScraperContext context) {
        BaseElementDef elseDef;
        IfDef[] ifDefs = this.caseDef.getIfDefs();
        if (ifDefs != null) {
            for (int i = 0; i < ifDefs.length; ++i) {
                String condition = BaseTemplater.execute(ifDefs[i].getCondition(), scraper.getScriptEngine());
                if (!CommonUtil.isBooleanTrue(condition)) continue;
                Variable ifResult = new BodyProcessor(ifDefs[i]).run(scraper, context);
                this.debug(ifDefs[i], scraper, ifResult);
                return ifResult;
            }
        }
        if ((elseDef = this.caseDef.getElseDef()) != null) {
            Variable elseResult = new BodyProcessor(elseDef).run(scraper, context);
            this.debug(elseDef, scraper, elseResult);
            return elseResult;
        }
        return new EmptyVariable();
    }
}

