/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.webharvest.definition.XmlNode;
import org.webharvest.definition.XmlParser;
import org.webharvest.gui.Ide;
import org.webharvest.gui.ResourceManager;
import org.webharvest.gui.component.WHScrollPane;
import org.webharvest.utils.CommonUtil;
import org.xml.sax.InputSource;

public class WelcomePanel
extends JPanel
implements HyperlinkListener {
    private Ide ide;
    private JEditorPane htmlPane;

    public WelcomePanel(Ide ide) {
        this.ide = ide;
        this.setLayout(new BorderLayout(0, 0));
        this.htmlPane = new JEditorPane(){

            public void paint(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paint(g);
            }
        };
        this.htmlPane.setEditable(false);
        this.htmlPane.setContentType("text/html");
        this.htmlPane.setEditorKit(new HTMLEditorKit());
        this.htmlPane.setBorder(null);
        this.htmlPane.addHyperlinkListener(this);
        try {
            URL welcomeUrl = ResourceManager.getWelcomeUrl();
            String content = CommonUtil.readStringFromUrl(welcomeUrl);
            content = content.replaceAll("#program.version#", "2.001");
            ((HTMLDocument)this.htmlPane.getDocument()).setBase(ResourceManager.getWelcomeUrl());
            this.htmlPane.setText(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        WHScrollPane scrollPane = new WHScrollPane(this.htmlPane);
        this.add((Component)scrollPane, "Center");
        new Thread(){

            public void run() {
                WelcomePanel.this.downloadAddition();
            }
        }.start();
    }

    private synchronized void downloadAddition() {
        try {
            String content = CommonUtil.readStringFromUrl(new URL("http://web-harvest.sourceforge.net/welcome_add.xml"));
            XmlNode node = XmlParser.parse(new InputSource(new StringReader(content)));
            String versionValue = (String)node.get("version[0].number");
            String versionMessage = (String)node.get("version[0]._value");
            String startValue = (String)node.get("start[0]._value");
            String endValue = (String)node.get("end[0]._value");
            boolean hasStart = startValue != null && !"".equals(startValue.trim());
            boolean hasEnd = endValue != null && !"".equals(endValue.trim());
            boolean hasVersion = versionValue != null && !"".equals(versionValue.trim());
            boolean hasVersionMessage = versionMessage != null && !"".equals(versionMessage.trim());
            boolean isThereNewVersion = false;
            if (hasVersion && hasVersionMessage) {
                try {
                    double currVersion = Double.parseDouble("2.001");
                    double serverVersion = Double.parseDouble(versionValue);
                    isThereNewVersion = serverVersion > currVersion;
                }
                catch (NumberFormatException e) {
                    isThereNewVersion = false;
                }
            }
            if (hasStart || hasEnd || isThereNewVersion) {
                URL welcomeUrl = ResourceManager.getWelcomeUrl();
                String htmlPaneContent = CommonUtil.readStringFromUrl(welcomeUrl);
                htmlPaneContent = htmlPaneContent.replaceAll("#program.version#", "2.001");
                if (isThereNewVersion) {
                    htmlPaneContent = htmlPaneContent.replaceAll("<!--version-->", versionMessage);
                }
                if (hasStart) {
                    htmlPaneContent = htmlPaneContent.replaceAll("<!--start-->", startValue);
                }
                if (hasEnd) {
                    htmlPaneContent = htmlPaneContent.replaceAll("<!--end-->", endValue);
                }
                ((HTMLDocument)this.htmlPane.getDocument()).setBase(ResourceManager.getWelcomeUrl());
                this.htmlPane.setText(htmlPaneContent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String url = e.getDescription().toString();
            if ("#new".equalsIgnoreCase(url)) {
                this.ide.addTab();
            } else if ("#open".equalsIgnoreCase(url)) {
                this.ide.openConfigFromFile();
            } else if ("#settings".equalsIgnoreCase(url)) {
                this.ide.defineSettings();
            } else if ("#help".equalsIgnoreCase(url)) {
                this.ide.showHelp();
            } else if (url.toLowerCase().startsWith("download:")) {
                String exampleUrl = url.substring(9);
                this.ide.openConfigFromUrl(exampleUrl);
            } else {
                this.ide.openURLInBrowser(url);
            }
        }
    }
}

