/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.streamdefn.cassandra.internal.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CassandraConnectorHelper {
    private static final Log log = LogFactory.getLog(CassandraConnectorHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMElement getEventDefinitionStoreCredentials() {
        String carbonHome = System.getProperty("carbon.config.dir.path");
        String path = carbonHome + File.separator + "event-stream-definition-auth.xml";
        BufferedInputStream inputStream = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                log.info((Object)"There is no event-stream-definition-auth.xml. Using the default configuration");
                inputStream = new BufferedInputStream(new ByteArrayInputStream("<Cassandra/>".getBytes()));
            } else {
                inputStream = new BufferedInputStream(new FileInputStream(file));
            }
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement oMElement = builder.getDocumentElement();
            return oMElement;
        }
        catch (FileNotFoundException e) {
            log.error((Object)("event-stream-definition-auth.xmlcannot be found in the path : " + path), (Throwable)e);
        }
        catch (XMLStreamException e) {
            log.error((Object)("Invalid XML for event-stream-definition-auth.xml located in the path : " + path), (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ignored) {}
        }
        return null;
    }
}

