/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.streamdefn.cassandra.datastore;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import me.prettyprint.hector.api.Cluster;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.dataaccess.ClusterInformation;
import org.wso2.carbon.databridge.commons.Credentials;
import org.wso2.carbon.databridge.streamdefn.cassandra.datastore.CassandraConnector;
import org.wso2.carbon.databridge.streamdefn.cassandra.internal.util.Utils;

public class ClusterFactory {
    private static LoadingCache<Credentials, Cluster> clusterLoadingCache;
    private static Log log;
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    private static final String DEFAULT_HOST = "localhost:9160";
    private static final String LOCAL_HOST_NAME = "localhost";

    private ClusterFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Class<ClusterFactory> clazz = ClusterFactory.class;
        synchronized (ClusterFactory.class) {
            if (clusterLoadingCache != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            clusterLoadingCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Credentials, Cluster>(){

                public Cluster load(Credentials credentials) throws Exception {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Cache not hit. Loading cluster for user : " + credentials.getUsername()));
                    }
                    ClusterInformation clusterInformation = new ClusterInformation(credentials.getUsername(), credentials.getPassword());
                    Cluster cluster = Utils.getDataAccessService().getCluster(clusterInformation);
                    ClusterFactory.initCassandraKeySpaces(cluster);
                    return cluster;
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void initCassandraKeySpaces(Cluster cluster) {
        log.info((Object)"Initializing cluster");
        CassandraConnector connector = Utils.getCassandraConnector();
        connector.createKeySpaceIfNotExisting(cluster, "BAM_AGENT_API_META_DATA");
        connector.createKeySpaceIfNotExisting(cluster, "EVENT_KS");
        connector.createColumnFamily(cluster, "BAM_AGENT_API_META_DATA", "AGENT_STREAM_ID");
        connector.createColumnFamily(cluster, "BAM_AGENT_API_META_DATA", "STREAM_DEF_ID_KEY");
        connector.createColumnFamily(cluster, "BAM_AGENT_API_META_DATA", "STREAM_ID_TO_STREAM_ID_KEY");
        connector.createColumnFamily(cluster, "BAM_AGENT_API_META_DATA", "AGENT_STREAM_DEF");
    }

    public static Cluster getCluster(Credentials credentials) {
        ClusterFactory.init();
        return (Cluster)clusterLoadingCache.getUnchecked((Object)credentials);
    }

    static {
        log = LogFactory.getLog(ClusterFactory.class);
    }
}

