/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.streamdefn.cassandra.Utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import me.prettyprint.cassandra.serializers.BooleanSerializer;
import me.prettyprint.cassandra.serializers.DoubleSerializer;
import me.prettyprint.cassandra.serializers.FloatSerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.streamdefn.cassandra.datastore.DataType;

public class CassandraSDSUtils {
    private static final StringSerializer stringSerializer = StringSerializer.get();
    private static final IntegerSerializer integerSerializer = IntegerSerializer.get();
    private static final LongSerializer longSerializer = LongSerializer.get();
    private static final BooleanSerializer booleanSerializer = BooleanSerializer.get();
    private static final FloatSerializer floatSerializer = FloatSerializer.get();
    private static final DoubleSerializer doubleSerializer = DoubleSerializer.get();

    public static String convertStreamNameToCFName(String streamName) {
        if (streamName == null) {
            return null;
        }
        int keySpaceLength = "EVENT_KS".length();
        if (streamName.length() + keySpaceLength > 48) {
            throw new RuntimeException("The stream name you provided is too long. This has caused the generated key (\"" + streamName + "\") to go " + "beyond the allowed characters. of " + (48 - keySpaceLength));
        }
        return streamName.replace(".", "_");
    }

    public static long getLong(ByteBuffer byteBuffer) throws IOException {
        return longSerializer.fromByteBuffer(byteBuffer);
    }

    public static String getString(ByteBuffer byteBuffer) throws IOException {
        return stringSerializer.fromByteBuffer(byteBuffer);
    }

    public static Object getOriginalValueFromColumnValue(ByteBuffer byteBuffer, AttributeType attributeType) throws IOException {
        switch (attributeType) {
            case BOOL: {
                return booleanSerializer.fromByteBuffer(byteBuffer);
            }
            case INT: {
                return integerSerializer.fromByteBuffer(byteBuffer);
            }
            case DOUBLE: {
                return doubleSerializer.fromByteBuffer(byteBuffer);
            }
            case FLOAT: {
                return floatSerializer.fromByteBuffer(byteBuffer);
            }
            case LONG: {
                return longSerializer.fromByteBuffer(byteBuffer);
            }
            case STRING: {
                return stringSerializer.fromByteBuffer(byteBuffer);
            }
        }
        return null;
    }

    public static String getColumnName(DataType dataType, Attribute attribute) {
        return dataType.name() + "_" + attribute.getName();
    }

    public static String createRowKey(long timestamp, UUID uuid) {
        return timestamp + "::" + uuid.toString();
    }
}

