/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.streamdefn.cassandra.datastore;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.wso2.carbon.databridge.commons.Credentials;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;
import org.wso2.carbon.databridge.streamdefn.cassandra.datastore.CassandraConnector;
import org.wso2.carbon.databridge.streamdefn.cassandra.datastore.ClusterFactory;

public class CassandraStreamDefinitionStore
extends AbstractStreamDefinitionStore {
    Logger log = Logger.getLogger(CassandraStreamDefinitionStore.class);
    CassandraConnector cassandraConnector = new CassandraConnector();

    protected void saveStreamIdToStore(Credentials credentials, String streamIdKey, String streamId) throws StreamDefinitionStoreException {
        this.cassandraConnector.saveStreamIdToStore(ClusterFactory.getCluster(credentials), streamIdKey, streamId);
    }

    protected void saveStreamDefinitionToStore(Credentials credentials, String streamId, StreamDefinition streamDefinition) throws StreamDefinitionStoreException {
        this.cassandraConnector.saveStreamDefinitionToStore(ClusterFactory.getCluster(credentials), streamId, streamDefinition);
    }

    protected String getStreamIdFromStore(Credentials credentials, String streamIdKey) throws StreamDefinitionStoreException {
        return this.cassandraConnector.getStreamIdFromStore(ClusterFactory.getCluster(credentials), streamIdKey);
    }

    public StreamDefinition getStreamDefinitionFromStore(Credentials credentials, String streamId) throws StreamDefinitionStoreException {
        return this.cassandraConnector.getStreamDefinitionFromStore(ClusterFactory.getCluster(credentials), streamId);
    }

    protected Collection<StreamDefinition> getAllStreamDefinitionsFromStore(Credentials credentials) throws StreamDefinitionStoreException {
        return this.cassandraConnector.getAllStreamDefinitionFromStore(ClusterFactory.getCluster(credentials));
    }
}

