/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.thrift.converter;

import com.google.gson.Gson;
import java.util.LinkedList;
import java.util.List;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.thrift.data.ThriftEventBundle;
import org.wso2.carbon.databridge.core.EventConverter;
import org.wso2.carbon.databridge.core.StreamTypeHolder;
import org.wso2.carbon.databridge.core.exception.EventConversionException;
import org.wso2.carbon.databridge.receiver.thrift.converter.IndexCounter;

public final class ThriftEventConverter
implements EventConverter {
    private static Gson gson = new Gson();

    public Object[] toObjectArray(ThriftEventBundle thriftEventBundle, AttributeType[] attributeTypeOrder, IndexCounter indexCounter) {
        if (attributeTypeOrder != null) {
            Object[] objects = new Object[attributeTypeOrder.length];
            block8: for (int i = 0; i < attributeTypeOrder.length; ++i) {
                switch (attributeTypeOrder[i]) {
                    case INT: {
                        objects[i] = thriftEventBundle.getIntAttributeList().get(indexCounter.getIntCount());
                        indexCounter.incrementIntCount();
                        continue block8;
                    }
                    case LONG: {
                        objects[i] = thriftEventBundle.getLongAttributeList().get(indexCounter.getLongCount());
                        indexCounter.incrementLongCount();
                        continue block8;
                    }
                    case STRING: {
                        String stringValue = (String)thriftEventBundle.getStringAttributeList().get(indexCounter.getStringCount());
                        objects[i] = stringValue.equals("_null") ? null : stringValue;
                        indexCounter.incrementStringCount();
                        continue block8;
                    }
                    case DOUBLE: {
                        objects[i] = thriftEventBundle.getDoubleAttributeList().get(indexCounter.getDoubleCount());
                        indexCounter.incrementDoubleCount();
                        continue block8;
                    }
                    case FLOAT: {
                        objects[i] = Float.valueOf(((Double)thriftEventBundle.getDoubleAttributeList().get(indexCounter.getDoubleCount())).floatValue());
                        indexCounter.incrementDoubleCount();
                        continue block8;
                    }
                    case BOOL: {
                        objects[i] = thriftEventBundle.getBoolAttributeList().get(indexCounter.getBoolCount());
                        indexCounter.incrementBoolCount();
                    }
                }
            }
            return objects;
        }
        return null;
    }

    public List<Event> toEventList(Object eventBundle, StreamTypeHolder streamTypeHolder) {
        if (eventBundle instanceof ThriftEventBundle) {
            return this.createEventList((ThriftEventBundle)eventBundle, streamTypeHolder);
        }
        throw new EventConversionException("Wrong type event relieved " + eventBundle.getClass());
    }

    private List<Event> createEventList(ThriftEventBundle thriftEventBundle, StreamTypeHolder streamTypeHolder) {
        IndexCounter indexCounter = new IndexCounter();
        LinkedList<Event> eventList = new LinkedList<Event>();
        String streamId = null;
        try {
            for (int i = 0; i < thriftEventBundle.getEventNum(); ++i) {
                Event event = new Event();
                streamId = (String)thriftEventBundle.getStringAttributeList().get(indexCounter.getStringCount());
                indexCounter.incrementStringCount();
                event.setStreamId(streamId);
                long timeStamp = (Long)thriftEventBundle.getLongAttributeList().get(indexCounter.getLongCount());
                indexCounter.incrementLongCount();
                event.setTimeStamp(timeStamp);
                AttributeType[] metaAttributeTypeOrder = streamTypeHolder.getMetaDataType(streamId);
                AttributeType[] correlationAttributeTypeOrder = streamTypeHolder.getCorrelationDataType(streamId);
                AttributeType[] payloadAttributeTypeOrder = streamTypeHolder.getPayloadDataType(streamId);
                event.setMetaData(this.toObjectArray(thriftEventBundle, metaAttributeTypeOrder, indexCounter));
                event.setCorrelationData(this.toObjectArray(thriftEventBundle, correlationAttributeTypeOrder, indexCounter));
                event.setPayloadData(this.toObjectArray(thriftEventBundle, payloadAttributeTypeOrder, indexCounter));
                eventList.add(event);
            }
        }
        catch (RuntimeException re) {
            throw new EventConversionException("Error when converting " + streamId + " of event bundle with events " + thriftEventBundle.getEventNum(), (Throwable)re);
        }
        return eventList;
    }
}

