/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.thrift.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.databridge.commons.thrift.service.general.ThriftEventTransmissionService;
import org.wso2.carbon.databridge.commons.thrift.service.secure.ThriftSecureEventTransmissionService;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.exception.DataBridgeException;
import org.wso2.carbon.databridge.receiver.thrift.ThriftDataReceiverFactory;
import org.wso2.carbon.databridge.receiver.thrift.conf.ThriftDataReceiverConfiguration;
import org.wso2.carbon.databridge.receiver.thrift.internal.ThriftDataReceiver;
import org.wso2.carbon.databridge.receiver.thrift.internal.utils.ThriftDataReceiverBuilder;
import org.wso2.carbon.databridge.receiver.thrift.service.ThriftEventTransmissionServiceImpl;
import org.wso2.carbon.databridge.receiver.thrift.service.ThriftEventTransmissionServlet;
import org.wso2.carbon.databridge.receiver.thrift.service.ThriftSecureEventTransmissionServiceImpl;
import org.wso2.carbon.databridge.receiver.thrift.service.ThriftSecureEventTransmissionServlet;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ThriftDataReceiverDS {
    private static final Log log = LogFactory.getLog(ThriftDataReceiverDS.class);
    private DataBridgeReceiverService dataBridgeReceiverService;
    private ServerConfigurationService serverConfiguration;
    private ConfigurationContextService configurationContext;
    private ThriftDataReceiver dataReceiver;
    private HttpService httpServiceInstance;

    protected void activate(ComponentContext context) {
        block6: {
            try {
                int portOffset = ThriftDataReceiverBuilder.readPortOffset(this.serverConfiguration);
                ThriftDataReceiverConfiguration thriftDataReceiverConfiguration = new ThriftDataReceiverConfiguration(7711 + portOffset, 7611 + portOffset);
                ThriftDataReceiverBuilder.populateConfigurations(portOffset, thriftDataReceiverConfiguration, this.dataBridgeReceiverService.getInitialConfig());
                if (this.dataReceiver != null) break block6;
                this.dataReceiver = new ThriftDataReceiverFactory().createAgentServer(thriftDataReceiverConfiguration, this.dataBridgeReceiverService);
                String serverUrl = CarbonUtils.getServerURL((ServerConfigurationService)this.serverConfiguration, (ConfigurationContext)this.configurationContext.getServerConfigContext());
                String hostName = null;
                try {
                    hostName = new URL(serverUrl).getHost();
                }
                catch (MalformedURLException e) {
                    log.warn((Object)("The server url :" + serverUrl + " is malformed URL hence hostname is assigned as 'localhost'"));
                    hostName = "localhost";
                }
                this.dataReceiver.start(hostName);
                log.info((Object)"Successfully deployed Agent Server ");
                ThriftEventTransmissionService.Processor processor = new ThriftEventTransmissionService.Processor((ThriftEventTransmissionService.Iface)new ThriftEventTransmissionServiceImpl(this.dataBridgeReceiverService));
                TCompactProtocol.Factory inProtFactory = new TCompactProtocol.Factory();
                TCompactProtocol.Factory outProtFactory = new TCompactProtocol.Factory();
                this.httpServiceInstance.registerServlet("/thriftReceiver", (Servlet)new ThriftEventTransmissionServlet((TProcessor)processor, (TProtocolFactory)inProtFactory, (TProtocolFactory)outProtFactory), new Hashtable(), this.httpServiceInstance.createDefaultHttpContext());
                ThriftSecureEventTransmissionService.Processor authProcessor = new ThriftSecureEventTransmissionService.Processor((ThriftSecureEventTransmissionService.Iface)new ThriftSecureEventTransmissionServiceImpl(this.dataBridgeReceiverService));
                this.httpServiceInstance.registerServlet("/thriftAuthenticator", (Servlet)new ThriftSecureEventTransmissionServlet((TProcessor)authProcessor, (TProtocolFactory)inProtFactory, (TProtocolFactory)outProtFactory), new Hashtable(), this.httpServiceInstance.createDefaultHttpContext());
            }
            catch (DataBridgeException e) {
                log.error((Object)"Can not create and start Agent Server ", (Throwable)e);
            }
            catch (RuntimeException e) {
                log.error((Object)"Error in starting Agent Server ", (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)"Error in starting Agent Server ", e);
            }
        }
    }

    protected void deactivate(ComponentContext context) {
        this.dataReceiver.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully stopped agent server");
        }
    }

    protected void setServerConfiguration(ServerConfigurationService serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfiguration) {
        this.serverConfiguration = null;
    }

    protected void setConfigurationContext(ConfigurationContextService configurationContext) {
        this.configurationContext = configurationContext;
    }

    protected void unsetConfigurationContext(ConfigurationContextService configurationContext) {
        this.configurationContext = null;
    }

    protected void setDataBridgeReceiverService(DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = dataBridgeReceiverService;
    }

    protected void unsetDatabridgeReceiverService(DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = null;
    }

    protected void setHttpService(HttpService httpService) {
        this.httpServiceInstance = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpServiceInstance = null;
    }
}

