/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.thrift.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.carbon.databridge.commons.thrift.service.general.ThriftEventTransmissionService;
import org.wso2.carbon.databridge.commons.thrift.service.secure.ThriftSecureEventTransmissionService;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.exception.DataBridgeException;
import org.wso2.carbon.databridge.receiver.thrift.conf.ThriftDataReceiverConfiguration;
import org.wso2.carbon.databridge.receiver.thrift.service.ThriftEventTransmissionServiceImpl;
import org.wso2.carbon.databridge.receiver.thrift.service.ThriftSecureEventTransmissionServiceImpl;

public class ThriftDataReceiver {
    private static final Log log = LogFactory.getLog(ThriftDataReceiver.class);
    private DataBridgeReceiverService dataBridgeReceiverService;
    private ThriftDataReceiverConfiguration thriftDataReceiverConfiguration;
    private TServer authenticationServer;
    private TServer dataReceiverServer;

    public ThriftDataReceiver(int secureReceiverPort, int receiverPort, DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = dataBridgeReceiverService;
        this.thriftDataReceiverConfiguration = new ThriftDataReceiverConfiguration(secureReceiverPort, receiverPort);
    }

    public ThriftDataReceiver(int receiverPort, DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = dataBridgeReceiverService;
        this.thriftDataReceiverConfiguration = new ThriftDataReceiverConfiguration(receiverPort + 100, receiverPort);
    }

    public ThriftDataReceiver(ThriftDataReceiverConfiguration thriftDataReceiverConfiguration, DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = dataBridgeReceiverService;
        this.thriftDataReceiverConfiguration = thriftDataReceiverConfiguration;
    }

    public void start(String hostName) throws DataBridgeException {
        this.startSecureEventTransmission(hostName, this.thriftDataReceiverConfiguration.getSecureDataReceiverPort(), this.dataBridgeReceiverService);
        this.startEventTransmission(this.thriftDataReceiverConfiguration.getDataReceiverPort(), this.dataBridgeReceiverService);
    }

    private void startSecureEventTransmission(String hostName, int port, DataBridgeReceiverService dataBridgeReceiverService) throws DataBridgeException {
        try {
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            String keyStore = serverConfig.getFirstProperty("Security.KeyStore.Location");
            if (keyStore == null && (keyStore = System.getProperty("Security.KeyStore.Location")) == null) {
                throw new DataBridgeException("Cannot start agent server, not valid Security.KeyStore.Location is null");
            }
            String keyStorePassword = serverConfig.getFirstProperty("Security.KeyStore.Password");
            if (keyStorePassword == null && (keyStorePassword = System.getProperty("Security.KeyStore.Password")) == null) {
                throw new DataBridgeException("Cannot start agent server, not valid Security.KeyStore.Password is null ");
            }
            this.startSecureEventTransmission(hostName, port, keyStore, keyStorePassword, dataBridgeReceiverService);
        }
        catch (TransportException e) {
            throw new DataBridgeException("Cannot start agent server on port " + port, (Throwable)e);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
    }

    protected void startSecureEventTransmission(String hostName, int port, String keyStore, String keyStorePassword, DataBridgeReceiverService dataBridgeReceiverService) throws TransportException, UnknownHostException {
        TServerSocket serverTransport;
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setKeyStore(keyStore, keyStorePassword);
        try {
            serverTransport = TSSLTransportFactory.getServerSocket((int)port, (int)30000, (InetAddress)InetAddress.getByName(hostName), (TSSLTransportFactory.TSSLTransportParameters)params);
        }
        catch (TTransportException e) {
            throw new TransportException("Thrift transport exception occurred ", (Throwable)e);
        }
        ThriftSecureEventTransmissionService.Processor processor = new ThriftSecureEventTransmissionService.Processor((ThriftSecureEventTransmissionService.Iface)new ThriftSecureEventTransmissionServiceImpl(dataBridgeReceiverService));
        this.authenticationServer = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor));
        Thread thread = new Thread(new ServerThread(this.authenticationServer));
        log.info((Object)("Thrift SSL port : " + port));
        thread.start();
    }

    protected void startEventTransmission(int port, DataBridgeReceiverService dataBridgeReceiverService) throws DataBridgeException {
        try {
            TServerSocket serverTransport = new TServerSocket(port);
            ThriftEventTransmissionService.Processor processor = new ThriftEventTransmissionService.Processor((ThriftEventTransmissionService.Iface)new ThriftEventTransmissionServiceImpl(dataBridgeReceiverService));
            this.dataReceiverServer = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor));
            Thread thread = new Thread(new ServerThread(this.dataReceiverServer));
            log.info((Object)("Thrift port : " + port));
            thread.start();
        }
        catch (TTransportException e) {
            throw new DataBridgeException("Cannot start Thrift server on port " + port, (Throwable)e);
        }
    }

    public void stop() {
        this.authenticationServer.stop();
        this.dataReceiverServer.stop();
    }

    static class ServerThread
    implements Runnable {
        private TServer server;

        ServerThread(TServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            this.server.serve();
        }
    }
}

