/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.restapi;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.databridge.commons.utils.EventDefinitionConverterUtils;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;
import org.wso2.carbon.databridge.receiver.restapi.utils.RESTUtils;

@Path(value="/")
public class StreamsService {
    private static Log log = LogFactory.getLog(StreamsService.class);

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response saveStreamDefn(String requestBody, @Context HttpServletRequest request) {
        try {
            DataBridgeReceiverService dataBridgeReceiverService = (DataBridgeReceiverService)SuperTenantCarbonContext.getCurrentContext().getOSGiService(DataBridgeReceiverService.class);
            StreamDefinition streamDefinition = EventDefinitionConverterUtils.convertFromJson((String)requestBody);
            dataBridgeReceiverService.saveStreamDefinition(RESTUtils.getSessionId((HttpServletRequest)request), streamDefinition);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        catch (MalformedStreamDefinitionException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (StreamDefinitionStoreException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (SessionTimeoutException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

