/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.thrift.service;

import org.apache.thrift.TException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.databridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.databridge.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.databridge.commons.thrift.data.ThriftEventBundle;
import org.wso2.carbon.databridge.commons.thrift.exception.ThriftDifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.thrift.exception.ThriftMalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.thrift.exception.ThriftNoStreamDefinitionExistException;
import org.wso2.carbon.databridge.commons.thrift.exception.ThriftSessionExpiredException;
import org.wso2.carbon.databridge.commons.thrift.exception.ThriftUndefinedEventTypeException;
import org.wso2.carbon.databridge.commons.thrift.service.general.ThriftEventTransmissionService;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.EventConverter;
import org.wso2.carbon.databridge.receiver.thrift.converter.ThriftEventConverter;

public class ThriftEventTransmissionServiceImpl
implements ThriftEventTransmissionService.Iface {
    private DataBridgeReceiverService dataBridgeReceiverService;
    private EventConverter eventConverter = new ThriftEventConverter();

    public ThriftEventTransmissionServiceImpl(DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = dataBridgeReceiverService;
    }

    public String defineStream(String sessionId, String streamDefinition) throws TException, ThriftSessionExpiredException, ThriftDifferentStreamDefinitionAlreadyDefinedException, ThriftMalformedStreamDefinitionException {
        try {
            return this.dataBridgeReceiverService.defineStream(sessionId, streamDefinition);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            throw new ThriftDifferentStreamDefinitionAlreadyDefinedException(e.getErrorMessage());
        }
        catch (MalformedStreamDefinitionException e) {
            throw new ThriftMalformedStreamDefinitionException(e.getErrorMessage());
        }
        catch (SessionTimeoutException e) {
            throw new ThriftSessionExpiredException(e.getErrorMessage());
        }
    }

    public String findStreamId(String sessionId, String streamName, String streamVersion) throws ThriftNoStreamDefinitionExistException, ThriftSessionExpiredException, TException {
        try {
            return this.dataBridgeReceiverService.findStreamId(sessionId, streamName, streamVersion);
        }
        catch (NoStreamDefinitionExistException e) {
            throw new ThriftNoStreamDefinitionExistException(e.getErrorMessage());
        }
        catch (SessionTimeoutException e) {
            throw new ThriftSessionExpiredException(e.getErrorMessage());
        }
    }

    public void publish(ThriftEventBundle eventBundle) throws ThriftUndefinedEventTypeException, ThriftSessionExpiredException, TException {
        try {
            this.dataBridgeReceiverService.publish((Object)eventBundle, eventBundle.getSessionId(), this.eventConverter);
        }
        catch (UndefinedEventTypeException e) {
            throw new ThriftUndefinedEventTypeException(e.getErrorMessage());
        }
        catch (SessionTimeoutException e) {
            throw new ThriftSessionExpiredException(e.getErrorMessage());
        }
    }
}

