/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.thrift.internal.utils;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.databridge.receiver.thrift.conf.ThriftDataReceiverConfiguration;

public final class ThriftDataReceiverBuilder {
    private static final Log log = LogFactory.getLog(ThriftDataReceiverBuilder.class);

    private ThriftDataReceiverBuilder() {
    }

    private static void populatePorts(OMElement config, int portOffset, ThriftDataReceiverConfiguration thriftDataReceiverConfiguration) {
        OMElement receiverPort;
        OMElement secureDataReceiverPort = config.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge", "securePort"));
        if (secureDataReceiverPort != null) {
            try {
                thriftDataReceiverConfiguration.setSecureDataReceiverPort(Integer.parseInt(secureDataReceiverPort.getText()) + portOffset);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if ((receiverPort = config.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge", "port"))) != null) {
            try {
                thriftDataReceiverConfiguration.setDataReceiverPort(Integer.parseInt(receiverPort.getText()) + portOffset);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
    }

    public static int readPortOffset(ServerConfigurationService serverConfiguration) {
        String portOffset = serverConfiguration.getFirstProperty("Ports.Offset");
        try {
            return portOffset != null ? Integer.parseInt(portOffset.trim()) : 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static void populateConfigurations(int portOffset, ThriftDataReceiverConfiguration thriftDataReceiverConfiguration, OMElement initialConfig) {
        OMElement thriftReceiverConfig;
        if (initialConfig != null && (thriftReceiverConfig = initialConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge", "thriftDataReceiver"))) != null) {
            ThriftDataReceiverBuilder.populatePorts(thriftReceiverConfig, portOffset, thriftDataReceiverConfiguration);
        }
    }
}

