/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.restapi.utils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.wso2.carbon.databridge.commons.Credentials;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.restapi.internal.Utils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class RESTUtils {
    public static Credentials extractAuthHeaders(HttpServletRequest request) {
        String authzHeader = request.getHeader("Authorization");
        return RESTUtils.extractAuthHeaders(authzHeader);
    }

    public static Credentials extractAuthHeaders(String authHeader) {
        String usernameAndPassword = new String(Base64.decodeBase64((byte[])authHeader.substring(6).getBytes()));
        int userNameIndex = usernameAndPassword.indexOf(":");
        String userName = usernameAndPassword.substring(0, userNameIndex);
        return new Credentials(userName, usernameAndPassword.substring(userNameIndex + 1), MultitenantUtils.getTenantDomain((String)userName));
    }

    public static boolean authenticate(HttpServletRequest request) {
        Credentials credentials = RESTUtils.extractAuthHeaders(request);
        try {
            String sessionId = Utils.getDataBridgeReceiver().login(credentials.getUsername(), credentials.getPassword());
            HttpSession session = request.getSession(true);
            session.setAttribute("session.id", (Object)sessionId);
            return true;
        }
        catch (AuthenticationException e) {
            return false;
        }
    }

    public static boolean isAuthenticated(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        Object attribute = session.getAttribute("session.id");
        return attribute != null;
    }

    public static String getSessionId(HttpServletRequest request) {
        return (String)request.getSession().getAttribute("session.id");
    }
}

