/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.restapi.rest;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.databridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.databridge.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.databridge.commons.utils.EventConverterUtils;
import org.wso2.carbon.databridge.commons.utils.EventDefinitionConverterUtils;
import org.wso2.carbon.databridge.core.EventConverter;
import org.wso2.carbon.databridge.core.StreamTypeHolder;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionNotFoundException;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;
import org.wso2.carbon.databridge.restapi.internal.Utils;
import org.wso2.carbon.databridge.restapi.utils.RESTUtils;

@Path(value="/")
public class EventResource {
    private static Log log = LogFactory.getLog(EventResource.class);

    @POST
    @Path(value="/{stream}/{version}")
    @Consumes(value={"application/json"})
    public Response publishEvent(@PathParam(value="stream") String streamName, @PathParam(value="version") String version, String requestBody, @Context HttpServletRequest request) {
        try {
            final String streamId = Utils.getDataBridgeReceiver().findStreamId(RESTUtils.getSessionId(request), streamName, version);
            Utils.getDataBridgeReceiver().publish((Object)requestBody, RESTUtils.getSessionId(request), new EventConverter(){

                public List<Event> toEventList(Object jsonEvents, StreamTypeHolder streamTypeHolder) {
                    return EventConverterUtils.convertFromJson((String)((String)jsonEvents), (String)streamId);
                }
            });
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        catch (UndefinedEventTypeException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (SessionTimeoutException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (NoStreamDefinitionExistException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response saveStreamDefn(String requestBody, @Context HttpServletRequest request) {
        try {
            StreamDefinition streamDefinition = EventDefinitionConverterUtils.convertFromJson((String)requestBody);
            Utils.getDataBridgeReceiver().saveStreamDefinition(RESTUtils.getSessionId(request), streamDefinition);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        catch (MalformedStreamDefinitionException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (StreamDefinitionStoreException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (SessionTimeoutException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{stream}/{version}")
    public Response getStreamDefinition(@PathParam(value="stream") String streamName, @PathParam(value="version") String version, @Context HttpServletRequest request) {
        try {
            StreamDefinition streamDefinition = Utils.getDataBridgeReceiver().getStreamDefinition(RESTUtils.getSessionId(request), streamName, version);
            String json = EventDefinitionConverterUtils.convertToJson((StreamDefinition)streamDefinition);
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (SessionTimeoutException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (StreamDefinitionStoreException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (StreamDefinitionNotFoundException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getAllStreamDefinitions(@Context HttpServletRequest request) {
        try {
            List allStreamDefinitions = Utils.getDataBridgeReceiver().getAllStreamDefinitions(RESTUtils.getSessionId(request));
            String json = EventDefinitionConverterUtils.convertToJson((List)allStreamDefinitions);
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (SessionTimeoutException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

