/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.core.conf.DataBridgeConfiguration;
import org.wso2.carbon.databridge.core.exception.DataBridgeConfigurationException;

public final class DataBridgeCoreBuilder {
    private static final Log log = LogFactory.getLog(DataBridgeCoreBuilder.class);

    private DataBridgeCoreBuilder() {
    }

    public static OMElement loadConfigXML() throws DataBridgeConfigurationException {
        String carbonHome = System.getProperty("carbon.config.dir.path");
        String path = carbonHome + File.separator + "data-bridge" + File.separator + "data-bridge-config.xml";
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(new File(path)));
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement omElement = builder.getDocumentElement();
            omElement.build();
            OMElement oMElement = omElement;
            return oMElement;
        }
        catch (FileNotFoundException e) {
            String errorMessage = "data-bridge-config.xmlcannot be found in the path : " + path;
            log.error((Object)errorMessage, (Throwable)e);
            throw new DataBridgeConfigurationException(errorMessage, e);
        }
        catch (XMLStreamException e) {
            String errorMessage = "Invalid XML for data-bridge-config.xml located in the path : " + path;
            log.error((Object)errorMessage, (Throwable)e);
            throw new DataBridgeConfigurationException(errorMessage, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                String errorMessage = "Can not close the input stream";
                log.error((Object)errorMessage, (Throwable)e);
            }
        }
    }

    public static void populateStreamDefinitions(OMElement config, List<String[]> streamDefinitionList) {
        OMElement streamDefinitions = config.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge", "streamDefinitions"));
        if (streamDefinitions != null) {
            Iterator streamDefinitionIterator = streamDefinitions.getChildElements();
            while (streamDefinitionIterator.hasNext()) {
                OMElement streamDefinition = (OMElement)streamDefinitionIterator.next();
                String domainName = streamDefinition.getAttributeValue(new QName("domainName"));
                streamDefinitionList.add(new String[]{domainName, streamDefinition.getText()});
            }
        }
    }

    public static void populateStreamDefinitionStore(OMElement config, DataBridgeConfiguration dataBridgeConfiguration) {
        OMElement streamDefinitionStore = config.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge", "StreamDefinitionStore"));
        if (streamDefinitionStore != null) {
            dataBridgeConfiguration.setStreamDefinitionStoreName(streamDefinitionStore.getText());
        }
    }

    public static void populateRuntimeParameters(OMElement config, DataBridgeConfiguration dataBridgeConfiguration) {
        OMElement clientTimeout;
        OMElement eventBufferCapacity;
        OMElement workerThreads = config.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge", "workerThreads"));
        if (workerThreads != null) {
            try {
                dataBridgeConfiguration.setWorkerThreads(Integer.parseInt(workerThreads.getText()));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if ((eventBufferCapacity = config.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge", "eventBufferCapacity"))) != null) {
            try {
                dataBridgeConfiguration.setEventBufferCapacity(Integer.parseInt(eventBufferCapacity.getText()));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if ((clientTimeout = config.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge", "clientTimeoutMS"))) != null) {
            try {
                dataBridgeConfiguration.setClientTimeOut(Integer.parseInt(clientTimeout.getText()));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
    }

    public static void populateConfigurations(DataBridgeConfiguration dataBridgeConfiguration, List<String[]> streamDefinitions, OMElement bridgeConfig) throws DataBridgeConfigurationException {
        if (bridgeConfig != null) {
            if (!bridgeConfig.getQName().equals(new QName("http://wso2.org/carbon/databridge", "dataBridgeConfiguration"))) {
                throw new DataBridgeConfigurationException("Invalid root element in data Bridge server config");
            }
            DataBridgeCoreBuilder.populateStreamDefinitions(bridgeConfig, streamDefinitions);
            DataBridgeCoreBuilder.populateStreamDefinitionStore(bridgeConfig, dataBridgeConfiguration);
        }
    }
}

