/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal.queue;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.core.AgentCallback;
import org.wso2.carbon.databridge.core.exception.EventConversionException;
import org.wso2.carbon.databridge.core.internal.utils.EventComposite;

public class QueueWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(QueueWorker.class);
    private BlockingQueue<EventComposite> eventQueue;
    private List<AgentCallback> subscribers;

    public QueueWorker(BlockingQueue<EventComposite> queue, List<AgentCallback> subscribers) {
        this.eventQueue = queue;
        this.subscribers = subscribers;
    }

    @Override
    public void run() {
        List<Event> eventList = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.eventQueue.size() + " messages in queue before " + Thread.currentThread().getName() + " worker has polled queue"));
            }
            EventComposite eventComposite = (EventComposite)this.eventQueue.poll();
            try {
                eventList = eventComposite.getEventConverter().toEventList(eventComposite.getEventBundle(), eventComposite.getStreamTypeHolder());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dispatching event to " + this.subscribers.size() + " subscriber(s)"));
                }
                for (AgentCallback agentCallback : this.subscribers) {
                    agentCallback.receive(eventList, eventComposite.getAgentSession().getCredentials());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.eventQueue.size() + " messages in queue after " + Thread.currentThread().getName() + " worker has finished work"));
                }
            }
            catch (EventConversionException re) {
                log.error((Object)("Wrongly formatted event sent for " + eventComposite.getStreamTypeHolder().getDomainName()), (Throwable)re);
            }
        }
        catch (Throwable e) {
            log.error((Object)("Error in passing events " + eventList + " to subscribers " + this.subscribers), e);
        }
    }
}

