/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal.authentication.session;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.wso2.carbon.databridge.core.internal.authentication.session.AgentSession;
import org.wso2.carbon.databridge.core.internal.authentication.session.SessionBean;

public class SessionCache {
    private ConcurrentMap<SessionBean, AgentSession> sessionCache;

    public SessionCache(int expirationTimeInMinutes) {
        this.sessionCache = new MapMaker().expiration((long)expirationTimeInMinutes, TimeUnit.MINUTES).makeComputingMap((Function)new SessionFunction());
    }

    public AgentSession getSession(SessionBean sessionBean) {
        return (AgentSession)this.sessionCache.get(sessionBean);
    }

    public void removeSession(String sessionId) {
        this.sessionCache.remove(sessionId);
    }

    static class SessionFunction
    implements Function<SessionBean, AgentSession> {
        SessionFunction() {
        }

        public AgentSession apply(SessionBean sessionBean) {
            return new AgentSession(sessionBean.getSessionId(), sessionBean.getCredentials());
        }
    }
}

