/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal.authentication;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Credentials;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.core.conf.DataBridgeConfiguration;
import org.wso2.carbon.databridge.core.internal.authentication.AuthenticationHandler;
import org.wso2.carbon.databridge.core.internal.authentication.session.AgentSession;
import org.wso2.carbon.databridge.core.internal.authentication.session.SessionBean;
import org.wso2.carbon.databridge.core.internal.authentication.session.SessionCache;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public final class Authenticator {
    private static final Log log = LogFactory.getLog(Authenticator.class);
    private SessionCache sessionCache;
    private AuthenticationHandler authenticationHandler;

    public Authenticator(AuthenticationHandler authenticationHandler, DataBridgeConfiguration dataBridgeConfiguration) {
        this.authenticationHandler = authenticationHandler;
        this.sessionCache = new SessionCache(dataBridgeConfiguration.getClientTimeOut() / 1000);
    }

    public String authenticate(String userName, String password) throws AuthenticationException {
        boolean isSuccessful;
        if (userName == null) {
            this.logAndAuthenticationException("Authentication request was missing the user name ");
        }
        if (password == null) {
            this.logAndAuthenticationException("Authentication request was missing the required password");
        }
        if (isSuccessful = this.authenticationHandler.authenticate(userName, password)) {
            String sessionId = UUID.randomUUID().toString();
            Credentials credentials = new Credentials(userName, password, MultitenantUtils.getTenantDomain((String)userName));
            this.sessionCache.getSession(new SessionBean(sessionId, credentials));
            return sessionId;
        }
        this.logAndAuthenticationException("wrong userName or password");
        return null;
    }

    private void logAndAuthenticationException(String msg) throws AuthenticationException {
        log.error((Object)msg);
        throw new AuthenticationException(msg);
    }

    public void logout(String sessionId) {
        this.sessionCache.removeSession(sessionId);
    }

    public AgentSession getSession(String sessionId) {
        return this.sessionCache.getSession(new SessionBean(sessionId));
    }
}

