/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Credentials;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.databridge.commons.utils.EventDefinitionConverterUtils;
import org.wso2.carbon.databridge.core.AgentCallback;
import org.wso2.carbon.databridge.core.EventConverter;
import org.wso2.carbon.databridge.core.StreamTypeHolder;
import org.wso2.carbon.databridge.core.conf.DataBridgeConfiguration;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionNotFoundException;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;
import org.wso2.carbon.databridge.core.internal.authentication.session.AgentSession;
import org.wso2.carbon.databridge.core.internal.queue.EventQueue;
import org.wso2.carbon.databridge.core.internal.utils.EventComposite;

public class EventDispatcher {
    public static final String HACK_DOMAIN_CONSTANT = "-1234";
    private List<AgentCallback> subscribers = new ArrayList<AgentCallback>();
    private AbstractStreamDefinitionStore streamDefinitionStore;
    private Map<String, StreamTypeHolder> streamTypeCache = new ConcurrentHashMap<String, StreamTypeHolder>();
    private EventQueue eventQueue;
    private static final Log log = LogFactory.getLog(EventDispatcher.class);

    public EventDispatcher(AbstractStreamDefinitionStore streamDefinitionStore, DataBridgeConfiguration dataBridgeConfiguration) {
        this.eventQueue = new EventQueue(this.subscribers, dataBridgeConfiguration);
        this.streamDefinitionStore = streamDefinitionStore;
    }

    public void addCallback(AgentCallback agentCallback) {
        this.subscribers.add(agentCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String defineStream(String streamDefinition, AgentSession agentSession) throws MalformedStreamDefinitionException, DifferentStreamDefinitionAlreadyDefinedException, StreamDefinitionStoreException {
        Class<EventDispatcher> clazz = EventDispatcher.class;
        synchronized (EventDispatcher.class) {
            StreamDefinition newStreamDefinition = EventDefinitionConverterUtils.convertFromJson((String)streamDefinition);
            try {
                StreamDefinition existingStreamDefinition = this.streamDefinitionStore.getStreamDefinition(agentSession.getCredentials(), newStreamDefinition.getName(), newStreamDefinition.getVersion());
                if (!existingStreamDefinition.equals((Object)newStreamDefinition)) {
                    throw new DifferentStreamDefinitionAlreadyDefinedException("Similar event stream for " + newStreamDefinition + " with the same name and version already exist: " + this.streamDefinitionStore.getStreamDefinition(agentSession.getCredentials(), newStreamDefinition.getName(), newStreamDefinition.getVersion()));
                }
                newStreamDefinition = existingStreamDefinition;
            }
            catch (StreamDefinitionNotFoundException e) {
                this.streamDefinitionStore.saveStreamDefinition(agentSession.getCredentials(), newStreamDefinition);
                this.updateStreamTypeCache(agentSession.getDomainName(), newStreamDefinition);
            }
            for (AgentCallback agentCallback : this.subscribers) {
                agentCallback.definedStream(newStreamDefinition, agentSession.getCredentials());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return newStreamDefinition.getStreamId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStreamTypeCache(String domainName, StreamDefinition streamDefinition) {
        Class<EventDispatcher> clazz = EventDispatcher.class;
        synchronized (EventDispatcher.class) {
            StreamTypeHolder streamTypeHolder = this.streamTypeCache.containsKey(domainName) ? this.streamTypeCache.get(domainName) : new StreamTypeHolder(domainName);
            this.updateStreamTypeHolder(streamTypeHolder, streamDefinition);
            if (log.isTraceEnabled()) {
                String logMsg = "Event Stream Type getting updated : ";
                logMsg = logMsg + "Event stream holder for domain name : " + domainName + " : \n ";
                logMsg = logMsg + "Correlation Data Type Map : " + streamTypeHolder.getCorrelationDataTypeMap() + "\n";
                logMsg = logMsg + "Payload Data Type Map : " + streamTypeHolder.getPayloadDataTypeMap() + "\n";
                logMsg = logMsg + "Meta Data Type Map : " + streamTypeHolder.getMetaDataTypeMap() + "\n";
                log.trace((Object)logMsg);
            }
            this.streamTypeCache.put(domainName, streamTypeHolder);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    public void publish(Object eventBundle, AgentSession agentSession, EventConverter eventConverter) throws UndefinedEventTypeException {
        try {
            this.eventQueue.publish(new EventComposite(eventBundle, this.getStreamDefinitionHolder(agentSession.getCredentials()), agentSession, eventConverter));
        }
        catch (StreamDefinitionNotFoundException e) {
            throw new UndefinedEventTypeException("No event stream definition exist " + e.getErrorMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamTypeHolder getStreamDefinitionHolder(Credentials credentials) throws StreamDefinitionNotFoundException {
        StreamTypeHolder streamTypeHolder = this.streamTypeCache.get(credentials.getDomainName());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Retrieving Event Stream Type Cache : " + this.streamTypeCache));
        }
        if (streamTypeHolder != null) {
            if (log.isDebugEnabled()) {
                String logMsg = "Event stream holder for domain name : " + credentials.getDomainName() + " : \n ";
                logMsg = logMsg + "Correlation Data Type Map : " + streamTypeHolder.getCorrelationDataTypeMap() + "\n";
                logMsg = logMsg + "Payload Data Type Map : " + streamTypeHolder.getPayloadDataTypeMap() + "\n";
                logMsg = logMsg + "Meta Data Type Map : " + streamTypeHolder.getMetaDataTypeMap() + "\n";
                log.debug((Object)logMsg);
            }
            return streamTypeHolder;
        }
        Object logMsg = EventDispatcher.class;
        synchronized (EventDispatcher.class) {
            streamTypeHolder = new StreamTypeHolder(credentials.getDomainName());
            Collection<StreamDefinition> allStreamDefinitions = this.streamDefinitionStore.getAllStreamDefinitions(credentials);
            for (StreamDefinition streamDefinition : allStreamDefinitions) {
                this.updateStreamTypeHolder(streamTypeHolder, streamDefinition);
                this.updateStreamTypeCache(credentials.getDomainName(), streamDefinition);
            }
            // ** MonitorExit[logMsg] (shouldn't be in output)
            if (log.isDebugEnabled()) {
                logMsg = "Event stream holder for domain name : " + credentials.getDomainName() + " : \n ";
                logMsg = (String)logMsg + "Correlation Data Type Map : " + streamTypeHolder.getCorrelationDataTypeMap() + "\n";
                logMsg = (String)logMsg + "Payload Data Type Map : " + streamTypeHolder.getPayloadDataTypeMap() + "\n";
                logMsg = (String)logMsg + "Meta Data Type Map : " + streamTypeHolder.getMetaDataTypeMap() + "\n";
                log.debug(logMsg);
            }
            return streamTypeHolder;
        }
    }

    private void updateStreamTypeHolder(StreamTypeHolder streamTypeHolder, StreamDefinition streamDefinition) {
        streamTypeHolder.setMetaDataType(streamDefinition.getStreamId(), EventDefinitionConverterUtils.generateAttributeTypeArray((List)streamDefinition.getMetaData()));
        streamTypeHolder.setCorrelationDataType(streamDefinition.getStreamId(), EventDefinitionConverterUtils.generateAttributeTypeArray((List)streamDefinition.getCorrelationData()));
        streamTypeHolder.setPayloadDataType(streamDefinition.getStreamId(), EventDefinitionConverterUtils.generateAttributeTypeArray((List)streamDefinition.getPayloadData()));
    }

    public List<AgentCallback> getSubscribers() {
        return this.subscribers;
    }

    public String findStreamId(Credentials credentials, String streamName, String streamVersion) throws StreamDefinitionNotFoundException, StreamDefinitionStoreException {
        try {
            return this.streamDefinitionStore.getStreamId(credentials, streamName, streamVersion);
        }
        catch (StreamDefinitionNotFoundException e) {
            throw new StreamDefinitionNotFoundException("No event stream definition exist " + e.getErrorMessage());
        }
    }

    private static class StreamTypeCache {
        private StreamTypeCache() {
        }
    }
}

