/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal;

import java.util.ArrayList;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.databridge.core.DataBridge;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.DataBridgeSubscriberService;
import org.wso2.carbon.databridge.core.conf.DataBridgeConfiguration;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.databridge.core.definitionstore.InMemoryStreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.DataBridgeConfigurationException;
import org.wso2.carbon.databridge.core.internal.authentication.CarbonAuthenticationHandler;
import org.wso2.carbon.databridge.core.internal.utils.DataBridgeCoreBuilder;
import org.wso2.carbon.identity.authentication.AuthenticationService;

public class DataBridgeDS {
    private static final Log log = LogFactory.getLog(DataBridgeDS.class);
    private AuthenticationService authenticationService;
    private ServiceRegistration receiverServiceRegistration;
    private ServiceRegistration subscriberServiceRegistration;
    private DataBridge databridge;
    private OMElement initialConfig;
    private ServiceRegistration databridgeRegistration;

    protected void activate(ComponentContext context) {
        block8: {
            try {
                DataBridgeConfiguration dataBridgeConfiguration = new DataBridgeConfiguration();
                ArrayList<String[]> streamDefinitions = new ArrayList<String[]>();
                try {
                    this.initialConfig = DataBridgeCoreBuilder.loadConfigXML();
                }
                catch (DataBridgeConfigurationException e) {
                    log.error((Object)"The data Bridge config was not found. Falling back to defaults.");
                }
                DataBridgeCoreBuilder.populateConfigurations(dataBridgeConfiguration, streamDefinitions, this.initialConfig);
                if (this.databridge != null) break block8;
                String definitionStoreName = dataBridgeConfiguration.getStreamDefinitionStoreName();
                AbstractStreamDefinitionStore streamDefinitionStore = null;
                try {
                    streamDefinitionStore = (AbstractStreamDefinitionStore)DataBridgeDS.class.getClassLoader().loadClass(definitionStoreName).newInstance();
                    if (definitionStoreName.equals("org.wso2.carbon.databridge.core.definitionstore.InMemoryStreamDefinitionStore")) {
                        log.warn((Object)("The default stream defintion store is loaded : " + definitionStoreName + ". Please configure a proper definition store."));
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("The stream definition store :" + definitionStoreName + " cannot be created. Hence using " + "org.wso2.carbon.databridge.core.definitionstore.InMemoryStreamDefinitionStore"), (Throwable)e);
                    streamDefinitionStore = new InMemoryStreamDefinitionStore();
                }
                this.databridge = new DataBridge(new CarbonAuthenticationHandler(this.authenticationService), streamDefinitionStore, dataBridgeConfiguration);
                this.databridge.setInitialConfig(this.initialConfig);
                this.receiverServiceRegistration = context.getBundleContext().registerService(DataBridgeReceiverService.class.getName(), (Object)this.databridge, null);
                this.subscriberServiceRegistration = context.getBundleContext().registerService(DataBridgeSubscriberService.class.getName(), (Object)this.databridge, null);
                log.info((Object)"Successfully deployed Agent Server ");
            }
            catch (DataBridgeConfigurationException e) {
                log.error((Object)"Agent Server Configuration is not correct hence can not create and start Agent Server ", (Throwable)e);
            }
            catch (RuntimeException e) {
                log.error((Object)"Error in starting Agent Server ", (Throwable)e);
            }
        }
    }

    protected void deactivate(ComponentContext context) {
        context.getBundleContext().ungetService(this.receiverServiceRegistration.getReference());
        context.getBundleContext().ungetService(this.subscriberServiceRegistration.getReference());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully stopped agent server");
        }
    }

    protected void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void unsetAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = null;
    }
}

