/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.definitionstore;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.databridge.commons.Credentials;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;

public class InMemoryStreamDefinitionStore
extends AbstractStreamDefinitionStore {
    private Map<String, HashMap<String, StreamDefinition>> streamDefinitionStore = new HashMap<String, HashMap<String, StreamDefinition>>();
    private Map<String, HashMap<String, String>> streamIdStore = new HashMap<String, HashMap<String, String>>();

    @Override
    protected void saveStreamIdToStore(Credentials credentials, String streamIdKey, String streamId) throws StreamDefinitionStoreException {
        if (!this.streamIdStore.containsKey(credentials.getDomainName())) {
            this.streamIdStore.put(credentials.getDomainName(), new HashMap());
        }
        this.streamIdStore.get(credentials.getDomainName()).put(streamIdKey, streamId);
    }

    @Override
    protected void saveStreamDefinitionToStore(Credentials credentials, String streamId, StreamDefinition streamDefinition) throws StreamDefinitionStoreException {
        if (!this.streamDefinitionStore.containsKey(credentials.getDomainName())) {
            this.streamDefinitionStore.put(credentials.getDomainName(), new HashMap());
        }
        this.streamDefinitionStore.get(credentials.getDomainName()).put(streamId, streamDefinition);
    }

    @Override
    protected String getStreamIdFromStore(Credentials credentials, String streamIdKey) throws StreamDefinitionStoreException {
        if (this.streamIdStore.get(credentials.getDomainName()) != null) {
            return this.streamIdStore.get(credentials.getDomainName()).get(streamIdKey);
        }
        return null;
    }

    @Override
    public StreamDefinition getStreamDefinitionFromStore(Credentials credentials, String streamId) throws StreamDefinitionStoreException {
        if (this.streamDefinitionStore.get(credentials.getDomainName()) != null) {
            return this.streamDefinitionStore.get(credentials.getDomainName()).get(streamId);
        }
        return null;
    }

    @Override
    public Collection<StreamDefinition> getAllStreamDefinitionsFromStore(Credentials credentials) {
        HashMap<String, StreamDefinition> map = this.streamDefinitionStore.get(credentials.getDomainName());
        if (map != null) {
            return map.values();
        }
        return null;
    }
}

