/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.definitionstore;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Credentials;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.utils.EventDefinitionConverterUtils;
import org.wso2.carbon.databridge.core.Utils.DataBridgeUtils;
import org.wso2.carbon.databridge.core.definitionstore.StreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionNotFoundException;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;

public abstract class AbstractStreamDefinitionStore
implements StreamDefinitionStore {
    private Log log = LogFactory.getLog(AbstractStreamDefinitionStore.class);

    private String constructNameVersionKey(String name, String version) {
        return DataBridgeUtils.constructStreamKey(name, version);
    }

    @Override
    public StreamDefinition getStreamDefinition(Credentials credentials, String name, String version) throws StreamDefinitionNotFoundException, StreamDefinitionStoreException {
        String streamId = this.getStreamIdFromStore(credentials, this.constructNameVersionKey(name, version));
        if (streamId == null) {
            throw new StreamDefinitionNotFoundException("No definitions exist on " + credentials.getUsername() + " for " + this.constructNameVersionKey(name, version));
        }
        return this.getStreamDefinition(credentials, streamId);
    }

    @Override
    public StreamDefinition getStreamDefinition(Credentials credentials, String streamId) throws StreamDefinitionNotFoundException, StreamDefinitionStoreException {
        StreamDefinition streamDefinition = this.getStreamDefinitionFromStore(credentials, streamId);
        if (streamDefinition == null) {
            throw new StreamDefinitionNotFoundException("No definitions exist on " + credentials.getUsername() + " for " + streamId);
        }
        return streamDefinition;
    }

    @Override
    public void saveStreamDefinition(Credentials credentials, StreamDefinition streamDefinition) throws DifferentStreamDefinitionAlreadyDefinedException, StreamDefinitionStoreException {
        StreamDefinition existingDefinition;
        try {
            existingDefinition = this.getStreamDefinition(credentials, streamDefinition.getName(), streamDefinition.getVersion());
        }
        catch (StreamDefinitionNotFoundException e) {
            this.saveStreamIdToStore(credentials, this.constructNameVersionKey(streamDefinition.getName(), streamDefinition.getVersion()), streamDefinition.getStreamId());
            this.saveStreamDefinitionToStore(credentials, streamDefinition.getStreamId(), streamDefinition);
            return;
        }
        if (!existingDefinition.equals((Object)streamDefinition)) {
            throw new DifferentStreamDefinitionAlreadyDefinedException("Another Stream with same name and version exist :" + EventDefinitionConverterUtils.convertToJson((StreamDefinition)existingDefinition));
        }
    }

    @Override
    public Collection<StreamDefinition> getAllStreamDefinitions(Credentials credentials) {
        try {
            return this.getAllStreamDefinitionsFromStore(credentials);
        }
        catch (StreamDefinitionStoreException e) {
            this.log.error((Object)"Error occured when trying to retrieve definitions. Returning empty list.");
            return new ArrayList<StreamDefinition>();
        }
    }

    @Override
    public String getStreamId(Credentials credentials, String streamName, String streamVersion) throws StreamDefinitionNotFoundException, StreamDefinitionStoreException {
        String streamId = this.getStreamIdFromStore(credentials, this.constructNameVersionKey(streamName, streamVersion));
        if (streamId == null) {
            throw new StreamDefinitionNotFoundException("No stream id found for " + streamId + " " + streamVersion);
        }
        return streamId;
    }

    protected abstract void saveStreamIdToStore(Credentials var1, String var2, String var3) throws StreamDefinitionStoreException;

    protected abstract void saveStreamDefinitionToStore(Credentials var1, String var2, StreamDefinition var3) throws StreamDefinitionStoreException;

    protected abstract String getStreamIdFromStore(Credentials var1, String var2) throws StreamDefinitionStoreException;

    public abstract StreamDefinition getStreamDefinitionFromStore(Credentials var1, String var2) throws StreamDefinitionStoreException;

    protected abstract Collection<StreamDefinition> getAllStreamDefinitionsFromStore(Credentials var1) throws StreamDefinitionStoreException;
}

