/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.Utils;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;

public class DataBridgeUtils {
    private static Log log = LogFactory.getLog(DataBridgeUtils.class);

    public static String constructStreamKey(String streamName, String version) {
        return streamName + "::" + version;
    }

    public static String getStreamNameFromStreamKey(String streamKey) {
        if (streamKey == null) {
            return null;
        }
        return streamKey.split("::")[0];
    }

    public static boolean equals(Event event1, Event event2, StreamDefinition streamDefinition) {
        if (event1 == event2) {
            return true;
        }
        List payloadDefinitions = streamDefinition.getPayloadData();
        List correlationDefinitions = streamDefinition.getCorrelationData();
        List metaDefinitions = streamDefinition.getMetaData();
        try {
            Attribute attribute;
            int i;
            if (!event1.getStreamId().equals(event2.getStreamId())) {
                return false;
            }
            if (event1.getTimeStamp() != event2.getTimeStamp()) {
                return false;
            }
            if (payloadDefinitions != null) {
                for (i = 0; i < payloadDefinitions.size(); ++i) {
                    attribute = (Attribute)payloadDefinitions.get(i);
                    if (DataBridgeUtils.compare(event1.getPayloadData()[i], event2.getPayloadData()[i], attribute.getType())) continue;
                    return false;
                }
            } else if (event1.getPayloadData() != event2.getPayloadData()) {
                return false;
            }
            if (metaDefinitions != null) {
                for (i = 0; i < metaDefinitions.size(); ++i) {
                    attribute = (Attribute)metaDefinitions.get(i);
                    if (DataBridgeUtils.compare(event1.getMetaData()[i], event2.getMetaData()[i], attribute.getType())) continue;
                    return false;
                }
            } else if (event1.getMetaData() != event2.getMetaData()) {
                return false;
            }
            if (correlationDefinitions != null) {
                for (i = 0; i < correlationDefinitions.size(); ++i) {
                    attribute = (Attribute)correlationDefinitions.get(i);
                    if (DataBridgeUtils.compare(event1.getCorrelationData()[i], event2.getCorrelationData()[i], attribute.getType())) continue;
                    return false;
                }
            } else if (event1.getCorrelationData() != event2.getCorrelationData()) {
                return false;
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean compare(Object eventAttr1, Object eventAttr2, AttributeType attributeType) throws IOException {
        switch (attributeType) {
            case BOOL: {
                if (eventAttr1 == eventAttr2) break;
                return false;
            }
            case INT: {
                Integer tempVal1 = eventAttr1 instanceof Integer ? ((Integer)eventAttr1).intValue() : ((Double)eventAttr1).intValue();
                Integer tempVal2 = eventAttr2 instanceof Integer ? ((Integer)eventAttr2).intValue() : ((Double)eventAttr2).intValue();
                if (tempVal1.equals(tempVal2)) break;
                return false;
            }
            case DOUBLE: {
                if (Double.compare((Double)eventAttr1, (Double)eventAttr2) == 0) break;
                return false;
            }
            case FLOAT: {
                if (Float.compare(((Double)eventAttr1).floatValue(), ((Double)eventAttr2).floatValue()) == 0) break;
                return false;
            }
            case LONG: {
                if (eventAttr1 == eventAttr2) break;
                return false;
            }
            case STRING: {
                return eventAttr1.equals(eventAttr2);
            }
        }
        return true;
    }
}

