/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Credentials;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.databridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.databridge.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.databridge.commons.utils.EventDefinitionConverterUtils;
import org.wso2.carbon.databridge.core.AgentCallback;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.DataBridgeSubscriberService;
import org.wso2.carbon.databridge.core.EventConverter;
import org.wso2.carbon.databridge.core.conf.DataBridgeConfiguration;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.databridge.core.definitionstore.StreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionNotFoundException;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;
import org.wso2.carbon.databridge.core.internal.EventDispatcher;
import org.wso2.carbon.databridge.core.internal.authentication.AuthenticationHandler;
import org.wso2.carbon.databridge.core.internal.authentication.Authenticator;
import org.wso2.carbon.databridge.core.internal.authentication.session.AgentSession;

public class DataBridge
implements DataBridgeSubscriberService,
DataBridgeReceiverService {
    private static final Log log = LogFactory.getLog(DataBridge.class);
    private StreamDefinitionStore streamDefinitionStore;
    private EventDispatcher eventDispatcher;
    private Authenticator authenticator;
    private OMElement initialConfig;

    public DataBridge(AuthenticationHandler authenticationHandler, AbstractStreamDefinitionStore streamDefinitionStore, DataBridgeConfiguration dataBridgeConfiguration) {
        this.eventDispatcher = new EventDispatcher(streamDefinitionStore, dataBridgeConfiguration);
        this.streamDefinitionStore = streamDefinitionStore;
        this.authenticator = new Authenticator(authenticationHandler, dataBridgeConfiguration);
    }

    public DataBridge(AuthenticationHandler authenticationHandler, AbstractStreamDefinitionStore streamDefinitionStore) {
        DataBridgeConfiguration dataBridgeConfiguration = new DataBridgeConfiguration();
        this.eventDispatcher = new EventDispatcher(streamDefinitionStore, dataBridgeConfiguration);
        this.streamDefinitionStore = streamDefinitionStore;
        this.authenticator = new Authenticator(authenticationHandler, dataBridgeConfiguration);
    }

    @Override
    public String defineStream(String sessionId, String streamDefinition) throws DifferentStreamDefinitionAlreadyDefinedException, MalformedStreamDefinitionException, SessionTimeoutException {
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getCredentials() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        try {
            return this.eventDispatcher.defineStream(streamDefinition, agentSession);
        }
        catch (MalformedStreamDefinitionException e) {
            throw new MalformedStreamDefinitionException(e.getErrorMessage(), (Throwable)e);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            throw new DifferentStreamDefinitionAlreadyDefinedException(e.getErrorMessage(), (Throwable)e);
        }
        catch (StreamDefinitionStoreException e) {
            throw new MalformedStreamDefinitionException(e.getErrorMessage(), (Throwable)e);
        }
    }

    @Override
    public String findStreamId(String sessionId, String streamName, String streamVersion) throws NoStreamDefinitionExistException, SessionTimeoutException {
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getCredentials() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        try {
            return this.eventDispatcher.findStreamId(agentSession.getCredentials(), streamName, streamVersion);
        }
        catch (StreamDefinitionNotFoundException e) {
            throw new NoStreamDefinitionExistException(e.getErrorMessage(), (Throwable)e);
        }
        catch (StreamDefinitionStoreException e) {
            throw new NoStreamDefinitionExistException(e.getErrorMessage(), (Throwable)e);
        }
    }

    @Override
    public void publish(Object eventBundle, String sessionId, EventConverter eventConverter) throws UndefinedEventTypeException, SessionTimeoutException {
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getCredentials() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        this.eventDispatcher.publish(eventBundle, agentSession, eventConverter);
    }

    @Override
    public String login(String username, String password) throws AuthenticationException {
        log.info((Object)(username + " connected"));
        return this.authenticator.authenticate(username, password);
    }

    @Override
    public void logout(String sessionId) throws Exception {
        log.info((Object)(sessionId + " disconnected"));
        this.authenticator.logout(sessionId);
    }

    @Override
    public OMElement getInitialConfig() {
        return this.initialConfig;
    }

    public void setInitialConfig(OMElement initialConfig) {
        this.initialConfig = initialConfig;
    }

    @Override
    public void subscribe(AgentCallback agentCallback) {
        this.eventDispatcher.addCallback(agentCallback);
    }

    @Override
    public StreamDefinition getStreamDefinition(String sessionId, String streamName, String streamVersion) throws SessionTimeoutException, StreamDefinitionNotFoundException, StreamDefinitionStoreException {
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getUsername() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        return this.getStreamDefinition(agentSession.getCredentials(), streamName, streamVersion);
    }

    @Override
    public List<StreamDefinition> getAllStreamDefinitions(String sessionId) throws SessionTimeoutException {
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getUsername() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        return this.getAllStreamDefinitions(agentSession.getCredentials());
    }

    @Override
    public void saveStreamDefinition(String sessionId, StreamDefinition streamDefinition) throws SessionTimeoutException, StreamDefinitionStoreException, DifferentStreamDefinitionAlreadyDefinedException {
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getUsername() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        this.saveStreamDefinition(agentSession.getCredentials(), streamDefinition);
    }

    @Override
    public StreamDefinition getStreamDefinition(Credentials credentials, String streamName, String streamVersion) throws StreamDefinitionNotFoundException, StreamDefinitionStoreException {
        return this.streamDefinitionStore.getStreamDefinition(credentials, streamName, streamVersion);
    }

    @Override
    public StreamDefinition getStreamDefinition(Credentials credentials, String streamId) throws StreamDefinitionNotFoundException, StreamDefinitionStoreException {
        return this.streamDefinitionStore.getStreamDefinition(credentials, streamId);
    }

    public List<StreamDefinition> getAllStreamDefinitions(Credentials credentials) {
        return new ArrayList<StreamDefinition>(this.streamDefinitionStore.getAllStreamDefinitions(credentials));
    }

    public void saveStreamDefinition(Credentials credentials, String streamDefinition) throws MalformedStreamDefinitionException, DifferentStreamDefinitionAlreadyDefinedException, StreamDefinitionStoreException {
        this.saveStreamDefinition(credentials, EventDefinitionConverterUtils.convertFromJson((String)streamDefinition));
    }

    @Override
    public void saveStreamDefinition(Credentials credentials, StreamDefinition streamDefinition) throws DifferentStreamDefinitionAlreadyDefinedException, StreamDefinitionStoreException {
        this.streamDefinitionStore.saveStreamDefinition(credentials, streamDefinition);
    }

    @Override
    public String getStreamId(Credentials credentials, String streamName, String streamVersion) throws StreamDefinitionNotFoundException, StreamDefinitionStoreException {
        return this.streamDefinitionStore.getStreamId(credentials, streamName, streamVersion);
    }

    @Override
    public List<AgentCallback> getSubscribers() {
        return this.eventDispatcher.getSubscribers();
    }
}

