/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core;

import java.util.List;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.databridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.databridge.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.EventConverter;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionNotFoundException;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;

public abstract class AbstractDataReceiver
implements DataBridgeReceiverService {
    @Override
    public String defineStream(String sessionId, String streamDefinition) throws DifferentStreamDefinitionAlreadyDefinedException, MalformedStreamDefinitionException, SessionTimeoutException {
        return this.getDatabridgeReceiver().defineStream(sessionId, streamDefinition);
    }

    @Override
    public String findStreamId(String sessionId, String streamName, String streamVersion) throws NoStreamDefinitionExistException, SessionTimeoutException {
        return this.getDatabridgeReceiver().findStreamId(sessionId, streamName, streamVersion);
    }

    @Override
    public void publish(Object eventBundle, String sessionId, EventConverter eventConverter) throws UndefinedEventTypeException, SessionTimeoutException {
        this.getDatabridgeReceiver().publish(eventBundle, sessionId, eventConverter);
    }

    @Override
    public String login(String username, String password) throws AuthenticationException {
        return this.getDatabridgeReceiver().login(username, password);
    }

    @Override
    public void logout(String sessionId) throws Exception {
        this.getDatabridgeReceiver().logout(sessionId);
    }

    @Override
    public StreamDefinition getStreamDefinition(String sessionId, String streamName, String streamVersion) throws SessionTimeoutException, StreamDefinitionNotFoundException, StreamDefinitionStoreException {
        return this.getDatabridgeReceiver().getStreamDefinition(sessionId, streamName, streamVersion);
    }

    @Override
    public List<StreamDefinition> getAllStreamDefinitions(String sessionId) throws SessionTimeoutException {
        return this.getDatabridgeReceiver().getAllStreamDefinitions(sessionId);
    }

    @Override
    public void saveStreamDefinition(String sessionId, StreamDefinition streamDefinition) throws SessionTimeoutException, StreamDefinitionStoreException, DifferentStreamDefinitionAlreadyDefinedException {
        this.getDatabridgeReceiver().saveStreamDefinition(sessionId, streamDefinition);
    }

    @Override
    public OMElement getInitialConfig() {
        return this.getDatabridgeReceiver().getInitialConfig();
    }

    protected abstract DataBridgeReceiverService getDatabridgeReceiver();
}

