/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.commons.utils;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;

public final class EventDefinitionConverterUtils {
    public static final String nullString = "_null";
    private static Gson gson = new Gson();

    private EventDefinitionConverterUtils() {
    }

    public static AttributeType[] generateAttributeTypeArray(List<Attribute> attributes) {
        if (attributes != null) {
            AttributeType[] attributeTypes = new AttributeType[attributes.size()];
            int metaDataSize = attributes.size();
            for (int i = 0; i < metaDataSize; ++i) {
                Attribute attribute = attributes.get(i);
                attributeTypes[i] = attribute.getType();
            }
            return attributeTypes;
        }
        return null;
    }

    public static StreamDefinition convertFromJson(String streamDefinition) throws MalformedStreamDefinitionException {
        try {
            StreamDefinition tempStreamDefinition = (StreamDefinition)gson.fromJson(streamDefinition.replaceAll("(?i)int", "INT").replaceAll("(?i)long", "LONG").replaceAll("(?i)float", "FLOAT").replaceAll("(?i)double", "DOUBLE").replaceAll("(?i)bool", "BOOL").replaceAll("(?i)string", "STRING"), StreamDefinition.class);
            String name = tempStreamDefinition.getName();
            String version = tempStreamDefinition.getVersion();
            if (version == null) {
                version = "1.0.0";
            }
            if (name == null) {
                throw new MalformedStreamDefinitionException("stream name is null");
            }
            String streamId = tempStreamDefinition.getStreamId();
            StreamDefinition newStreamDefinition = streamId == null ? new StreamDefinition(name, version) : new StreamDefinition(name, version, streamId);
            newStreamDefinition.setTags(tempStreamDefinition.getTags());
            newStreamDefinition.setMetaData(tempStreamDefinition.getMetaData());
            newStreamDefinition.setCorrelationData(tempStreamDefinition.getCorrelationData());
            newStreamDefinition.setPayloadData(tempStreamDefinition.getPayloadData());
            newStreamDefinition.setNickName(tempStreamDefinition.getNickName());
            newStreamDefinition.setDescription(tempStreamDefinition.getDescription());
            newStreamDefinition.setDescription(tempStreamDefinition.getDescription());
            newStreamDefinition.setTags(tempStreamDefinition.getTags());
            return newStreamDefinition;
        }
        catch (RuntimeException e) {
            throw new MalformedStreamDefinitionException(" Malformed stream definition " + streamDefinition, e);
        }
    }

    public static String convertToJson(List<StreamDefinition> existingDefinitions) {
        JSONArray jsonDefnArray = new JSONArray();
        for (StreamDefinition existingDefinition : existingDefinitions) {
            jsonDefnArray.put((Object)EventDefinitionConverterUtils.convertToJson(existingDefinition));
        }
        return gson.toJson(existingDefinitions);
    }

    public static List<StreamDefinition> convertMultipleEventDefns(String jsonArrayOfEventDefns) throws MalformedStreamDefinitionException {
        try {
            JSONArray jsonArray = new JSONArray(jsonArrayOfEventDefns);
            ArrayList<StreamDefinition> streamDefinitions = new ArrayList<StreamDefinition>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                streamDefinitions.add(EventDefinitionConverterUtils.convertFromJson(jsonArray.getString(i)));
            }
            return streamDefinitions;
        }
        catch (JSONException e) {
            throw new MalformedStreamDefinitionException(" Malformed stream definition " + jsonArrayOfEventDefns, e);
        }
    }

    public static String convertToJson(StreamDefinition existingDefinition) {
        return gson.toJson((Object)existingDefinition);
    }
}

