/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.commons.utils;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.MalformedEventException;

public class EventConverterUtils {
    private static Log log = LogFactory.getLog(EventConverterUtils.class);
    private static Gson gson = new Gson();

    public static List<Event> convertFromJson(String json) {
        ArrayList<Event> eventList = new ArrayList<Event>();
        try {
            JSONArray eventObjects = new JSONArray(json);
            for (int i = 0; i < eventObjects.length(); ++i) {
                Event event = (Event)gson.fromJson(eventObjects.get(i).toString(), Event.class);
                if (event.getStreamId() == null || event.getStreamId().equals("")) {
                    String errorMsg = "Stream Id cannot be null or empty, for JSON : " + eventObjects.get(i).toString();
                    MalformedEventException malformedEventException = new MalformedEventException();
                    if (log.isDebugEnabled()) {
                        log.error((Object)errorMsg, (Throwable)malformedEventException);
                    } else {
                        log.error((Object)errorMsg);
                    }
                    throw malformedEventException;
                }
                eventList.add(event);
            }
        }
        catch (JSONException e) {
            String errorMsg = "Error converting JSON to event, for JSON : " + json;
            MalformedEventException malformedEventException = new MalformedEventException(errorMsg, e);
            if (log.isDebugEnabled()) {
                log.error((Object)errorMsg, (Throwable)malformedEventException);
            } else {
                log.error((Object)errorMsg);
            }
            throw malformedEventException;
        }
        return eventList;
    }

    public static List<Event> convertFromJson(String json, String streamId) {
        if (streamId == null || streamId.equals("")) {
            String errorMsg = "Stream name cannot be null or empty";
            MalformedEventException malformedEventException = new MalformedEventException();
            if (log.isDebugEnabled()) {
                log.error((Object)errorMsg, (Throwable)malformedEventException);
            } else {
                log.error((Object)errorMsg);
            }
            throw malformedEventException;
        }
        ArrayList<Event> eventList = new ArrayList<Event>();
        try {
            JSONArray eventObjects = new JSONArray(json);
            for (int i = 0; i < eventObjects.length(); ++i) {
                Event event = (Event)gson.fromJson(eventObjects.get(i).toString(), Event.class);
                event.setStreamId(streamId);
                eventList.add(event);
            }
        }
        catch (JSONException e) {
            String errorMsg = "Error converting JSON to event, for JSON : " + json;
            MalformedEventException malformedEventException = new MalformedEventException(errorMsg, e);
            if (log.isDebugEnabled()) {
                log.error((Object)errorMsg, (Throwable)malformedEventException);
            } else {
                log.error((Object)errorMsg);
            }
            throw malformedEventException;
        }
        return eventList;
    }
}

