/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.commons;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;

public class StreamDefinition {
    private String streamId;
    private String name;
    private String version = "1.0.0";
    private String nickName;
    private String description;
    private List<String> tags;
    private List<Attribute> metaData;
    private List<Attribute> correlationData;
    private List<Attribute> payloadData;

    public StreamDefinition(String name, String version, String streamId) throws MalformedStreamDefinitionException {
        this.name = name;
        String versionPattern = "^\\d+\\.\\d+\\.\\d+$";
        if (!version.matches(versionPattern)) {
            throw new MalformedStreamDefinitionException("version " + version + " does not adhere to the format x.x.x ");
        }
        this.version = version;
        this.streamId = streamId;
    }

    public StreamDefinition(String name, String version) throws MalformedStreamDefinitionException {
        this.name = name;
        String versionPattern = "^\\d+\\.\\d+\\.\\d+$";
        if (!version.matches(versionPattern)) {
            throw new MalformedStreamDefinitionException("version " + version + " does not adhere to the format x.x.x ");
        }
        this.version = version;
        this.generateSteamId();
    }

    public StreamDefinition(String name) {
        this.name = name;
        this.generateSteamId();
    }

    private void generateSteamId() {
        if (this.streamId == null) {
            this.streamId = this.name + "-" + this.version + "-" + UUID.randomUUID();
        }
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setMetaData(List<Attribute> metaData) {
        this.metaData = metaData;
    }

    public void setCorrelationData(List<Attribute> correlationData) {
        this.correlationData = correlationData;
    }

    public void setPayloadData(List<Attribute> payloadData) {
        this.payloadData = payloadData;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<Attribute> getMetaData() {
        return this.metaData;
    }

    public List<Attribute> getCorrelationData() {
        return this.correlationData;
    }

    public List<Attribute> getPayloadData() {
        return this.payloadData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamDefinition that = (StreamDefinition)o;
        if (this.correlationData != null ? !((Object)this.correlationData).equals(that.correlationData) : that.correlationData != null) {
            return false;
        }
        if (this.metaData != null ? !((Object)this.metaData).equals(that.metaData) : that.metaData != null) {
            return false;
        }
        if (this.payloadData != null ? !((Object)this.payloadData).equals(that.payloadData) : that.payloadData != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + (this.metaData != null ? ((Object)this.metaData).hashCode() : 0);
        result = 31 * result + (this.correlationData != null ? ((Object)this.correlationData).hashCode() : 0);
        result = 31 * result + (this.payloadData != null ? ((Object)this.payloadData).hashCode() : 0);
        return result;
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tag);
    }

    public void addMetaData(String name, AttributeType type) {
        if (this.metaData == null) {
            this.metaData = new ArrayList<Attribute>();
        }
        this.metaData.add(new Attribute(name, type));
    }

    public void addCorrelationData(String name, AttributeType type) {
        if (this.correlationData == null) {
            this.correlationData = new ArrayList<Attribute>();
        }
        this.correlationData.add(new Attribute(name, type));
    }

    public void addPayloadData(String name, AttributeType type) {
        if (this.payloadData == null) {
            this.payloadData = new ArrayList<Attribute>();
        }
        this.payloadData.add(new Attribute(name, type));
    }

    public String toString() {
        return "StreamDefinition{streamId='" + this.streamId + '\'' + ", " + "name" + "='" + this.name + '\'' + ", " + "version" + "='" + this.version + '\'' + ", " + "nickName" + "='" + this.nickName + '\'' + ", " + "description" + "='" + this.description + '\'' + ", " + "tags" + "=" + this.tags + ", " + "metaData" + "=" + this.metaData + ", " + "correlationData" + "=" + this.correlationData + ", " + "payloadData" + "=" + this.payloadData + '}';
    }
}

